/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.packstream.io.value;

import io.netty.buffer.Unpooled;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.ValueWriter;

public abstract class PackstreamValueWriter
implements AnyValueWriter<RuntimeException> {
    protected final PackstreamBuf buf;

    public PackstreamValueWriter(PackstreamBuf target) {
        this.buf = target;
    }

    public void writeNull() {
        this.buf.writeNull();
    }

    public void writeBoolean(boolean value) {
        this.buf.writeBoolean(value);
    }

    public void writeInteger(byte value) {
        this.buf.writeInt(value);
    }

    public void writeInteger(short value) {
        this.buf.writeInt(value);
    }

    public void writeInteger(int value) {
        this.buf.writeInt(value);
    }

    public void writeInteger(long value) {
        this.buf.writeInt(value);
    }

    public void writeFloatingPoint(float value) {
        this.buf.writeFloat(value);
    }

    public void writeFloatingPoint(double value) {
        this.buf.writeFloat(value);
    }

    public void writeString(String value) {
        this.buf.writeString(value);
    }

    public void writeString(char value) {
        this.buf.writeString(Character.toString(value));
    }

    public void beginArray(int size, ValueWriter.ArrayType arrayType) {
        this.buf.writeListHeader(size);
    }

    public void endArray() {
    }

    public void writeByteArray(byte[] value) {
        this.buf.writeBytes(Unpooled.wrappedBuffer((byte[])value));
    }

    public AnyValueWriter.EntityMode entityMode() {
        return AnyValueWriter.EntityMode.FULL;
    }

    public void beginMap(int size) {
        this.buf.writeMapHeader(size);
    }

    public void endMap() {
    }

    public void beginList(int size) {
        this.buf.writeListHeader(size);
    }

    public void endList() {
    }

    public void writeNodeReference(long nodeId) {
        throw new UnsupportedOperationException("Cannot write raw node reference");
    }

    public void writeRelationshipReference(long relId) {
        throw new UnsupportedOperationException("Cannot write raw relationship reference");
    }

    public void writePathReference(long[] nodes, long[] relationships) {
        throw new UnsupportedOperationException("Cannot write raw path reference");
    }
}

