/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.packstream.util;

import java.util.OptionalLong;
import org.neo4j.packstream.error.struct.IllegalStructArgumentException;
import org.neo4j.packstream.util.PackstreamConditions;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;

public final class PackstreamConversions {
    private PackstreamConversions() {
    }

    public static ListValue asNullableListValue(String fieldName, AnyValue fieldValue) throws IllegalStructArgumentException {
        if (fieldValue == Values.NO_VALUE) {
            return null;
        }
        if (fieldValue instanceof ListValue) {
            ListValue listValue = (ListValue)fieldValue;
            return listValue;
        }
        throw new IllegalStructArgumentException(fieldName, "Expected list");
    }

    public static long asLong(String fieldName, Object fieldValue) throws IllegalStructArgumentException {
        PackstreamConditions.requireNonNull(fieldName, fieldValue);
        return PackstreamConversions.asNullableLong(fieldName, fieldValue);
    }

    public static Long asNullableLong(String fieldName, Object fieldValue) throws IllegalStructArgumentException {
        if (fieldValue instanceof Long) {
            Long longValue = (Long)fieldValue;
            return longValue;
        }
        if (fieldValue == null) {
            return null;
        }
        throw new IllegalStructArgumentException(fieldName, "Expected long");
    }

    public static long asLongValue(String fieldName, AnyValue fieldValue) throws IllegalStructArgumentException {
        if (fieldValue == Values.NO_VALUE) {
            throw new IllegalStructArgumentException(fieldName, "Expected value to be non-null");
        }
        return PackstreamConversions.asNullableLongValue(fieldName, fieldValue).orElseThrow(() -> new IllegalStructArgumentException(fieldName, "Expected long"));
    }

    public static OptionalLong asNullableLongValue(String fieldName, AnyValue fieldValue) throws IllegalStructArgumentException {
        if (fieldValue instanceof LongValue) {
            LongValue longValue = (LongValue)fieldValue;
            return OptionalLong.of(longValue.longValue());
        }
        if (fieldValue == Values.NO_VALUE) {
            return OptionalLong.empty();
        }
        throw new IllegalStructArgumentException(fieldName, "Expected long");
    }

    public static MapValue asNullableMapValue(String fieldName, AnyValue fieldValue) throws IllegalStructArgumentException {
        if (fieldValue instanceof MapValue) {
            MapValue mapValue = (MapValue)fieldValue;
            return mapValue;
        }
        if (fieldValue == Values.NO_VALUE) {
            return null;
        }
        throw new IllegalStructArgumentException(fieldName, "Expected dictionary");
    }

    public static String asString(String fieldName, Object fieldValue) throws IllegalStructArgumentException {
        PackstreamConditions.requireNonNull(fieldName, fieldValue);
        return PackstreamConversions.asNullableString(fieldName, fieldValue);
    }

    public static String asNullableString(String fieldName, Object fieldValue) throws IllegalStructArgumentException {
        if (fieldValue instanceof String) {
            String stringValue = (String)fieldValue;
            return stringValue;
        }
        if (fieldValue == null) {
            return null;
        }
        throw new IllegalStructArgumentException(fieldName, "Expected string");
    }

    public static String asNullableStringValue(String fieldName, AnyValue fieldValue) throws IllegalStructArgumentException {
        if (fieldValue instanceof TextValue) {
            TextValue textValue = (TextValue)fieldValue;
            return textValue.stringValue();
        }
        if (fieldValue == Values.NO_VALUE) {
            return null;
        }
        throw new IllegalStructArgumentException(fieldName, "Expected string");
    }
}

