/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import org.neo4j.causalclustering.VersionDecoder;
import org.neo4j.causalclustering.VersionPrepender;
import org.neo4j.causalclustering.catchup.CatchUpClient;
import org.neo4j.causalclustering.catchup.CatchUpResponseHandler;
import org.neo4j.causalclustering.catchup.CatchupClientProtocol;
import org.neo4j.causalclustering.catchup.ClientMessageTypeHandler;
import org.neo4j.causalclustering.catchup.RequestDecoderDispatcher;
import org.neo4j.causalclustering.catchup.RequestMessageTypeEncoder;
import org.neo4j.causalclustering.catchup.ResponseMessageTypeEncoder;
import org.neo4j.causalclustering.catchup.storecopy.FileChunkDecoder;
import org.neo4j.causalclustering.catchup.storecopy.FileChunkHandler;
import org.neo4j.causalclustering.catchup.storecopy.FileHeaderDecoder;
import org.neo4j.causalclustering.catchup.storecopy.FileHeaderHandler;
import org.neo4j.causalclustering.catchup.storecopy.GetStoreIdRequestEncoder;
import org.neo4j.causalclustering.catchup.storecopy.GetStoreIdResponseDecoder;
import org.neo4j.causalclustering.catchup.storecopy.GetStoreIdResponseHandler;
import org.neo4j.causalclustering.catchup.storecopy.GetStoreRequestEncoder;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFinishedResponseDecoder;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFinishedResponseHandler;
import org.neo4j.causalclustering.catchup.tx.TxPullRequestEncoder;
import org.neo4j.causalclustering.catchup.tx.TxPullResponseDecoder;
import org.neo4j.causalclustering.catchup.tx.TxPullResponseHandler;
import org.neo4j.causalclustering.catchup.tx.TxStreamFinishedResponseDecoder;
import org.neo4j.causalclustering.catchup.tx.TxStreamFinishedResponseHandler;
import org.neo4j.causalclustering.core.state.snapshot.CoreSnapshotDecoder;
import org.neo4j.causalclustering.core.state.snapshot.CoreSnapshotRequestEncoder;
import org.neo4j.causalclustering.core.state.snapshot.CoreSnapshotResponseHandler;
import org.neo4j.causalclustering.handlers.ExceptionLoggingHandler;
import org.neo4j.causalclustering.handlers.ExceptionMonitoringHandler;
import org.neo4j.causalclustering.handlers.ExceptionSwallowingHandler;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;

class CatchUpClientChannelPipeline {
    CatchUpClientChannelPipeline() {
    }

    static void initChannel(SocketChannel ch, CatchUpResponseHandler handler, LogProvider logProvider, Monitors monitors) throws Exception {
        CatchupClientProtocol protocol = new CatchupClientProtocol();
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, 0, 4)});
        pipeline.addLast(new ChannelHandler[]{new LengthFieldPrepender(4)});
        pipeline.addLast(new ChannelHandler[]{new VersionDecoder(logProvider)});
        pipeline.addLast(new ChannelHandler[]{new VersionPrepender()});
        pipeline.addLast(new ChannelHandler[]{new TxPullRequestEncoder()});
        pipeline.addLast(new ChannelHandler[]{new GetStoreRequestEncoder()});
        pipeline.addLast(new ChannelHandler[]{new CoreSnapshotRequestEncoder()});
        pipeline.addLast(new ChannelHandler[]{new GetStoreIdRequestEncoder()});
        pipeline.addLast(new ChannelHandler[]{new ResponseMessageTypeEncoder()});
        pipeline.addLast(new ChannelHandler[]{new RequestMessageTypeEncoder()});
        pipeline.addLast(new ChannelHandler[]{new ClientMessageTypeHandler(protocol, logProvider)});
        RequestDecoderDispatcher<CatchupClientProtocol.State> decoderDispatcher = new RequestDecoderDispatcher<CatchupClientProtocol.State>(protocol, logProvider);
        decoderDispatcher.register(CatchupClientProtocol.State.STORE_ID, (ChannelInboundHandler)new GetStoreIdResponseDecoder());
        decoderDispatcher.register(CatchupClientProtocol.State.TX_PULL_RESPONSE, (ChannelInboundHandler)new TxPullResponseDecoder());
        decoderDispatcher.register(CatchupClientProtocol.State.CORE_SNAPSHOT, (ChannelInboundHandler)new CoreSnapshotDecoder());
        decoderDispatcher.register(CatchupClientProtocol.State.STORE_COPY_FINISHED, (ChannelInboundHandler)new StoreCopyFinishedResponseDecoder());
        decoderDispatcher.register(CatchupClientProtocol.State.TX_STREAM_FINISHED, (ChannelInboundHandler)new TxStreamFinishedResponseDecoder());
        decoderDispatcher.register(CatchupClientProtocol.State.FILE_HEADER, (ChannelInboundHandler)new FileHeaderDecoder());
        decoderDispatcher.register(CatchupClientProtocol.State.FILE_CONTENTS, (ChannelInboundHandler)new FileChunkDecoder());
        pipeline.addLast(new ChannelHandler[]{decoderDispatcher});
        pipeline.addLast(new ChannelHandler[]{new TxPullResponseHandler(protocol, handler)});
        pipeline.addLast(new ChannelHandler[]{new CoreSnapshotResponseHandler(protocol, handler)});
        pipeline.addLast(new ChannelHandler[]{new StoreCopyFinishedResponseHandler(protocol, handler)});
        pipeline.addLast(new ChannelHandler[]{new TxStreamFinishedResponseHandler(protocol, handler)});
        pipeline.addLast(new ChannelHandler[]{new FileHeaderHandler(protocol, handler, logProvider)});
        pipeline.addLast(new ChannelHandler[]{new FileChunkHandler(protocol, handler)});
        pipeline.addLast(new ChannelHandler[]{new GetStoreIdResponseHandler(protocol, handler)});
        pipeline.addLast(new ChannelHandler[]{new ExceptionLoggingHandler(logProvider.getLog(CatchUpClient.class))});
        pipeline.addLast(new ChannelHandler[]{new ExceptionMonitoringHandler((ExceptionMonitoringHandler.Monitor)monitors.newMonitor(ExceptionMonitoringHandler.Monitor.class, CatchUpClient.class, new String[0]))});
        pipeline.addLast(new ChannelHandler[]{new ExceptionSwallowingHandler()});
    }
}

