/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.neo4j.causalclustering.catchup.storecopy.StoreFileStreams;
import org.neo4j.causalclustering.catchup.tx.FileCopyMonitor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.monitoring.Monitors;

class StreamToDisk
implements StoreFileStreams {
    private final File storeDir;
    private final FileSystemAbstraction fs;
    private final FileCopyMonitor fileCopyMonitor;

    StreamToDisk(File storeDir, FileSystemAbstraction fs, Monitors monitors) throws IOException {
        this.storeDir = storeDir;
        this.fs = fs;
        fs.mkdirs(storeDir);
        this.fileCopyMonitor = (FileCopyMonitor)monitors.newMonitor(FileCopyMonitor.class, new String[0]);
    }

    @Override
    public OutputStream createStream(String destination) throws IOException {
        File fileName = new File(this.storeDir, destination);
        this.fs.mkdirs(fileName.getParentFile());
        this.fileCopyMonitor.copyFile(fileName);
        return this.fs.openAsOutputStream(fileName, true);
    }
}

