/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.neo4j.causalclustering.core.consensus.MajorityIncludingSelfQuorum;
import org.neo4j.causalclustering.core.consensus.roles.follower.FollowerStates;

public class Followers {
    public static <MEMBER> long quorumAppendIndex(Set<MEMBER> votingMembers, FollowerStates<MEMBER> states) {
        TreeMap<Long, Integer> appendedCounts = new TreeMap<Long, Integer>();
        for (MEMBER member : votingMembers) {
            long txId = states.get(member).getMatchIndex();
            Integer currentCount = (Integer)appendedCounts.get(txId);
            if (currentCount == null) {
                appendedCounts.put(txId, 1);
                continue;
            }
            appendedCounts.put(txId, currentCount + 1);
        }
        int total = 0;
        for (Map.Entry entry : appendedCounts.descendingMap().entrySet()) {
            if (!MajorityIncludingSelfQuorum.isQuorum(votingMembers.size(), total += ((Integer)entry.getValue()).intValue())) continue;
            return (Long)entry.getKey();
        }
        return -1L;
    }
}

