/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.outcome;

import java.io.IOException;
import java.util.Arrays;
import org.neo4j.causalclustering.core.consensus.LeaderContext;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.shipping.RaftLogShipper;

public abstract class ShipCommand {
    public abstract void applyTo(RaftLogShipper var1, LeaderContext var2) throws IOException;

    public static class CommitUpdate
    extends ShipCommand {
        @Override
        public void applyTo(RaftLogShipper raftLogShipper, LeaderContext leaderContext) throws IOException {
            raftLogShipper.onCommitUpdate(leaderContext);
        }

        public String toString() {
            return "CommitUpdate{}";
        }
    }

    public static class NewEntries
    extends ShipCommand {
        private final long prevLogIndex;
        private final long prevLogTerm;
        private final RaftLogEntry[] newLogEntries;

        public NewEntries(long prevLogIndex, long prevLogTerm, RaftLogEntry[] newLogEntries) {
            this.prevLogIndex = prevLogIndex;
            this.prevLogTerm = prevLogTerm;
            this.newLogEntries = newLogEntries;
        }

        @Override
        public void applyTo(RaftLogShipper raftLogShipper, LeaderContext leaderContext) throws IOException {
            raftLogShipper.onNewEntries(this.prevLogIndex, this.prevLogTerm, this.newLogEntries, leaderContext);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NewEntries newEntries = (NewEntries)o;
            if (this.prevLogIndex != newEntries.prevLogIndex) {
                return false;
            }
            if (this.prevLogTerm != newEntries.prevLogTerm) {
                return false;
            }
            return Arrays.equals(this.newLogEntries, newEntries.newLogEntries);
        }

        public int hashCode() {
            int result = (int)(this.prevLogIndex ^ this.prevLogIndex >>> 32);
            result = 31 * result + (int)(this.prevLogTerm ^ this.prevLogTerm >>> 32);
            result = 31 * result + Arrays.hashCode(this.newLogEntries);
            return result;
        }

        public String toString() {
            return String.format("NewEntry{prevLogIndex=%d, prevLogTerm=%d, newLogEntry=%s}", this.prevLogIndex, this.prevLogTerm, Arrays.toString(this.newLogEntries));
        }
    }

    public static class Match
    extends ShipCommand {
        private final long newMatchIndex;
        private final Object target;

        public Match(long newMatchIndex, Object target) {
            this.newMatchIndex = newMatchIndex;
            this.target = target;
        }

        @Override
        public void applyTo(RaftLogShipper raftLogShipper, LeaderContext leaderContext) throws IOException {
            if (raftLogShipper.identity().equals(this.target)) {
                raftLogShipper.onMatch(this.newMatchIndex, leaderContext);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Match match = (Match)o;
            if (this.newMatchIndex != match.newMatchIndex) {
                return false;
            }
            return this.target.equals(match.target);
        }

        public int hashCode() {
            int result = (int)(this.newMatchIndex ^ this.newMatchIndex >>> 32);
            result = 31 * result + this.target.hashCode();
            return result;
        }

        public String toString() {
            return String.format("Match{newMatchIndex=%d, target=%s}", this.newMatchIndex, this.target);
        }
    }

    public static class Mismatch
    extends ShipCommand {
        private final long lastRemoteAppendIndex;
        private final Object target;

        public Mismatch(long lastRemoteAppendIndex, Object target) {
            this.lastRemoteAppendIndex = lastRemoteAppendIndex;
            this.target = target;
        }

        @Override
        public void applyTo(RaftLogShipper raftLogShipper, LeaderContext leaderContext) throws IOException {
            if (raftLogShipper.identity().equals(this.target)) {
                raftLogShipper.onMismatch(this.lastRemoteAppendIndex, leaderContext);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Mismatch mismatch = (Mismatch)o;
            if (this.lastRemoteAppendIndex != mismatch.lastRemoteAppendIndex) {
                return false;
            }
            return this.target.equals(mismatch.target);
        }

        public int hashCode() {
            int result = (int)(this.lastRemoteAppendIndex ^ this.lastRemoteAppendIndex >>> 32);
            result = 31 * result + this.target.hashCode();
            return result;
        }

        public String toString() {
            return String.format("Mismatch{lastRemoteAppendIndex=%d, target=%s}", this.lastRemoteAppendIndex, this.target);
        }
    }
}

