/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.roles;

import java.io.IOException;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.outcome.Outcome;
import org.neo4j.causalclustering.core.consensus.state.ReadableRaftState;
import org.neo4j.causalclustering.identity.MemberId;

public class Voting {
    static void handleVoteRequest(ReadableRaftState state, Outcome outcome, RaftMessages.Vote.Request voteRequest) throws IOException {
        boolean willVoteForCandidate;
        if (voteRequest.term() > state.term()) {
            outcome.setNextTerm(voteRequest.term());
            outcome.setVotedFor(null);
        }
        if (willVoteForCandidate = Voting.shouldVoteFor(voteRequest.candidate(), outcome.getTerm(), voteRequest.term(), state.entryLog().readEntryTerm(state.entryLog().appendIndex()), voteRequest.lastLogTerm(), state.entryLog().appendIndex(), voteRequest.lastLogIndex(), outcome.getVotedFor())) {
            outcome.setVotedFor(voteRequest.from());
            outcome.renewElectionTimeout();
        }
        outcome.addOutgoingMessage(new RaftMessages.Directed(voteRequest.from(), new RaftMessages.Vote.Response(state.myself(), outcome.getTerm(), willVoteForCandidate)));
    }

    public static boolean shouldVoteFor(MemberId candidate, long contextTerm, long requestTerm, long contextLastLogTerm, long requestLastLogTerm, long contextLastAppended, long requestLastLogIndex, MemberId votedFor) {
        if (requestTerm < contextTerm) {
            return false;
        }
        boolean requestLogEndsAtHigherTerm = requestLastLogTerm > contextLastLogTerm;
        boolean logsEndAtSameTerm = requestLastLogTerm == contextLastLogTerm;
        boolean requestLogAtLeastAsLongAsMyLog = requestLastLogIndex >= contextLastAppended;
        boolean requesterLogUpToDate = requestLogEndsAtHigherTerm || logsEndAtSameTerm && requestLogAtLeastAsLongAsMyLog;
        boolean votedForOtherInSameTerm = requestTerm == contextTerm && votedFor != null && !votedFor.equals(candidate);
        return requesterLogUpToDate && !votedForOtherInSameTerm;
    }
}

