/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.causalclustering.catchup.storecopy.LocalDatabase;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.consensus.LeaderLocator;
import org.neo4j.causalclustering.core.replication.RaftReplicator;
import org.neo4j.causalclustering.core.replication.Replicator;
import org.neo4j.causalclustering.core.state.machines.CoreStateMachines;
import org.neo4j.causalclustering.core.state.machines.id.IdAllocationState;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdAllocationStateMachine;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdGeneratorFactory;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdRangeAcquirer;
import org.neo4j.causalclustering.core.state.machines.locks.LeaderOnlyLockManager;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenState;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenStateMachine;
import org.neo4j.causalclustering.core.state.machines.token.ReplicatedLabelTokenHolder;
import org.neo4j.causalclustering.core.state.machines.token.ReplicatedPropertyKeyTokenHolder;
import org.neo4j.causalclustering.core.state.machines.token.ReplicatedRelationshipTypeTokenHolder;
import org.neo4j.causalclustering.core.state.machines.token.ReplicatedTokenStateMachine;
import org.neo4j.causalclustering.core.state.machines.token.TokenRegistry;
import org.neo4j.causalclustering.core.state.machines.tx.RecoverConsensusLogIndex;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransactionCommitProcess;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransactionStateMachine;
import org.neo4j.causalclustering.core.state.storage.DurableStateStorage;
import org.neo4j.causalclustering.core.state.storage.StateStorage;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.CommitProcessFactory;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipTypeToken;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.enterprise.id.EnterpriseIdTypeConfigurationProvider;
import org.neo4j.kernel.impl.factory.CommunityEditionModule;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.id.configuration.IdTypeConfigurationProvider;
import org.neo4j.kernel.impl.store.stats.IdBasedStoreEntityCounters;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.Token;
import org.neo4j.storageengine.api.TokenFactory;

public class CoreStateMachinesModule {
    public static final String ID_ALLOCATION_NAME = "id-allocation";
    public static final String LOCK_TOKEN_NAME = "lock-token";
    public final ReplicatedIdGeneratorFactory idGeneratorFactory;
    public final IdTypeConfigurationProvider idTypeConfigurationProvider;
    public final LabelTokenHolder labelTokenHolder;
    public final PropertyKeyTokenHolder propertyKeyTokenHolder;
    public final RelationshipTypeTokenHolder relationshipTypeTokenHolder;
    public final Locks lockManager;
    public final CommitProcessFactory commitProcessFactory;
    public final CoreStateMachines coreStateMachines;

    public CoreStateMachinesModule(MemberId myself, PlatformModule platformModule, File clusterStateDirectory, Config config, RaftReplicator replicator, LeaderLocator leaderLocator, Dependencies dependencies, LocalDatabase localDatabase) {
        LifeSupport life = platformModule.life;
        FileSystemAbstraction fileSystem = platformModule.fileSystem;
        LogService logging = platformModule.logging;
        LogProvider logProvider = logging.getInternalLogProvider();
        StateStorage lockTokenState = (StateStorage)life.add(new DurableStateStorage<ReplicatedLockTokenState>(fileSystem, clusterStateDirectory, LOCK_TOKEN_NAME, new ReplicatedLockTokenState.Marshal(new MemberId.Marshal()), (Integer)config.get(CausalClusteringSettings.replicated_lock_token_state_size), logProvider));
        StateStorage idAllocationState = (StateStorage)life.add(new DurableStateStorage<IdAllocationState>(fileSystem, clusterStateDirectory, ID_ALLOCATION_NAME, new IdAllocationState.Marshal(), (Integer)config.get(CausalClusteringSettings.id_alloc_state_size), logProvider));
        ReplicatedIdAllocationStateMachine idAllocationStateMachine = new ReplicatedIdAllocationStateMachine(idAllocationState);
        Map<IdType, Integer> allocationSizes = this.getIdTypeAllocationSizeFromConfig(config);
        ReplicatedIdRangeAcquirer idRangeAcquirer = new ReplicatedIdRangeAcquirer(replicator, idAllocationStateMachine, allocationSizes, myself, logProvider);
        this.idTypeConfigurationProvider = new EnterpriseIdTypeConfigurationProvider(config);
        this.idGeneratorFactory = (ReplicatedIdGeneratorFactory)((Object)dependencies.satisfyDependency((Object)this.createIdGeneratorFactory(fileSystem, idRangeAcquirer, logProvider, this.idTypeConfigurationProvider)));
        life.add((Lifecycle)this.idGeneratorFactory);
        dependencies.satisfyDependency((Object)new IdBasedStoreEntityCounters((IdGeneratorFactory)this.idGeneratorFactory));
        TokenRegistry<RelationshipTypeToken> relationshipTypeTokenRegistry = new TokenRegistry<RelationshipTypeToken>("RelationshipType");
        ReplicatedRelationshipTypeTokenHolder relationshipTypeTokenHolder = new ReplicatedRelationshipTypeTokenHolder(relationshipTypeTokenRegistry, replicator, this.idGeneratorFactory, dependencies);
        TokenRegistry<Token> propertyKeyTokenRegistry = new TokenRegistry<Token>("PropertyKey");
        ReplicatedPropertyKeyTokenHolder propertyKeyTokenHolder = new ReplicatedPropertyKeyTokenHolder(propertyKeyTokenRegistry, replicator, this.idGeneratorFactory, dependencies);
        TokenRegistry<Token> labelTokenRegistry = new TokenRegistry<Token>("Label");
        ReplicatedLabelTokenHolder labelTokenHolder = new ReplicatedLabelTokenHolder(labelTokenRegistry, replicator, this.idGeneratorFactory, dependencies);
        ReplicatedLockTokenStateMachine replicatedLockTokenStateMachine = new ReplicatedLockTokenStateMachine(lockTokenState);
        ReplicatedTokenStateMachine<Token> labelTokenStateMachine = new ReplicatedTokenStateMachine<Token>(labelTokenRegistry, (TokenFactory<Token>)new Token.Factory(), logProvider);
        ReplicatedTokenStateMachine<Token> propertyKeyTokenStateMachine = new ReplicatedTokenStateMachine<Token>(propertyKeyTokenRegistry, (TokenFactory<Token>)new Token.Factory(), logProvider);
        ReplicatedTokenStateMachine<RelationshipTypeToken> relationshipTypeTokenStateMachine = new ReplicatedTokenStateMachine<RelationshipTypeToken>(relationshipTypeTokenRegistry, (TokenFactory<RelationshipTypeToken>)new RelationshipTypeToken.Factory(), logProvider);
        ReplicatedTransactionStateMachine replicatedTxStateMachine = new ReplicatedTransactionStateMachine(replicatedLockTokenStateMachine, (Integer)config.get(CausalClusteringSettings.state_machine_apply_max_batch_size), logProvider);
        dependencies.satisfyDependencies(new Object[]{replicatedTxStateMachine});
        this.lockManager = this.createLockManager(config, logging, replicator, myself, leaderLocator, replicatedLockTokenStateMachine);
        RecoverConsensusLogIndex consensusLogIndexRecovery = new RecoverConsensusLogIndex(dependencies, logProvider);
        this.coreStateMachines = new CoreStateMachines(replicatedTxStateMachine, labelTokenStateMachine, relationshipTypeTokenStateMachine, propertyKeyTokenStateMachine, replicatedLockTokenStateMachine, idAllocationStateMachine, localDatabase, consensusLogIndexRecovery);
        this.commitProcessFactory = (appender, applier, ignored) -> {
            localDatabase.registerCommitProcessDependencies(appender, applier);
            return new ReplicatedTransactionCommitProcess(replicator);
        };
        this.relationshipTypeTokenHolder = relationshipTypeTokenHolder;
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
        this.labelTokenHolder = labelTokenHolder;
    }

    private Map<IdType, Integer> getIdTypeAllocationSizeFromConfig(Config config) {
        HashMap<IdType, Integer> allocationSizes = new HashMap<IdType, Integer>(IdType.values().length);
        allocationSizes.put(IdType.NODE, (Integer)config.get(CausalClusteringSettings.node_id_allocation_size));
        allocationSizes.put(IdType.RELATIONSHIP, (Integer)config.get(CausalClusteringSettings.relationship_id_allocation_size));
        allocationSizes.put(IdType.PROPERTY, (Integer)config.get(CausalClusteringSettings.property_id_allocation_size));
        allocationSizes.put(IdType.STRING_BLOCK, (Integer)config.get(CausalClusteringSettings.string_block_id_allocation_size));
        allocationSizes.put(IdType.ARRAY_BLOCK, (Integer)config.get(CausalClusteringSettings.array_block_id_allocation_size));
        allocationSizes.put(IdType.PROPERTY_KEY_TOKEN, (Integer)config.get(CausalClusteringSettings.property_key_token_id_allocation_size));
        allocationSizes.put(IdType.PROPERTY_KEY_TOKEN_NAME, (Integer)config.get(CausalClusteringSettings.property_key_token_name_id_allocation_size));
        allocationSizes.put(IdType.RELATIONSHIP_TYPE_TOKEN, (Integer)config.get(CausalClusteringSettings.relationship_type_token_id_allocation_size));
        allocationSizes.put(IdType.RELATIONSHIP_TYPE_TOKEN_NAME, (Integer)config.get(CausalClusteringSettings.relationship_type_token_name_id_allocation_size));
        allocationSizes.put(IdType.LABEL_TOKEN, (Integer)config.get(CausalClusteringSettings.label_token_id_allocation_size));
        allocationSizes.put(IdType.LABEL_TOKEN_NAME, (Integer)config.get(CausalClusteringSettings.label_token_name_id_allocation_size));
        allocationSizes.put(IdType.NEOSTORE_BLOCK, (Integer)config.get(CausalClusteringSettings.neostore_block_id_allocation_size));
        allocationSizes.put(IdType.SCHEMA, (Integer)config.get(CausalClusteringSettings.schema_id_allocation_size));
        allocationSizes.put(IdType.NODE_LABELS, (Integer)config.get(CausalClusteringSettings.node_labels_id_allocation_size));
        allocationSizes.put(IdType.RELATIONSHIP_GROUP, (Integer)config.get(CausalClusteringSettings.relationship_group_id_allocation_size));
        return allocationSizes;
    }

    private ReplicatedIdGeneratorFactory createIdGeneratorFactory(FileSystemAbstraction fileSystem, ReplicatedIdRangeAcquirer idRangeAcquirer, LogProvider logProvider, IdTypeConfigurationProvider idTypeConfigurationProvider) {
        return new ReplicatedIdGeneratorFactory(fileSystem, idRangeAcquirer, logProvider, idTypeConfigurationProvider);
    }

    private Locks createLockManager(Config config, LogService logging, Replicator replicator, MemberId myself, LeaderLocator leaderLocator, ReplicatedLockTokenStateMachine lockTokenStateMachine) {
        Locks localLocks = CommunityEditionModule.createLockManager((Config)config, (LogService)logging);
        return new LeaderOnlyLockManager(myself, replicator, leaderLocator, localLocks, lockTokenStateMachine);
    }
}

