/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.id;

import java.io.IOException;
import java.util.Arrays;
import org.neo4j.causalclustering.core.state.machines.id.UnallocatedIds;
import org.neo4j.causalclustering.core.state.storage.SafeStateMarshal;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class IdAllocationState
implements UnallocatedIds {
    private final long[] firstUnallocated;
    private long logIndex;

    IdAllocationState() {
        this(new long[IdType.values().length], -1L);
    }

    public IdAllocationState(long[] firstUnallocated, long logIndex) {
        this.firstUnallocated = firstUnallocated;
        this.logIndex = logIndex;
    }

    public long logIndex() {
        return this.logIndex;
    }

    public void logIndex(long logIndex) {
        this.logIndex = logIndex;
    }

    @Override
    public long firstUnallocated(IdType idType) {
        return this.firstUnallocated[idType.ordinal()];
    }

    void firstUnallocated(IdType idType, long idRangeEnd) {
        this.firstUnallocated[idType.ordinal()] = idRangeEnd;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdAllocationState that = (IdAllocationState)o;
        return this.logIndex == that.logIndex && Arrays.equals(this.firstUnallocated, that.firstUnallocated);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.firstUnallocated);
        result = 31 * result + (int)(this.logIndex ^ this.logIndex >>> 32);
        return result;
    }

    public IdAllocationState newInstance() {
        return new IdAllocationState((long[])this.firstUnallocated.clone(), this.logIndex);
    }

    public String toString() {
        return String.format("IdAllocationState{firstUnallocated=%s, logIndex=%d}", Arrays.toString(this.firstUnallocated), this.logIndex);
    }

    public static class Marshal
    extends SafeStateMarshal<IdAllocationState> {
        @Override
        public void marshal(IdAllocationState state, WritableChannel channel) throws IOException {
            channel.putLong((long)state.firstUnallocated.length);
            for (long l : state.firstUnallocated) {
                channel.putLong(l);
            }
            channel.putLong(state.logIndex);
        }

        @Override
        public IdAllocationState unmarshal0(ReadableChannel channel) throws IOException {
            long[] firstNotAllocated = new long[(int)channel.getLong()];
            for (int i = 0; i < firstNotAllocated.length; ++i) {
                firstNotAllocated[i] = channel.getLong();
            }
            long logIndex = channel.getLong();
            return new IdAllocationState(firstNotAllocated, logIndex);
        }

        @Override
        public IdAllocationState startState() {
            return new IdAllocationState();
        }

        @Override
        public long ordinal(IdAllocationState state) {
            return state.logIndex();
        }
    }
}

