/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.id;

import java.io.IOException;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdAllocationRequest;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.EndOfStreamException;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class ReplicatedIdAllocationRequestSerializer {
    public static void marshal(ReplicatedIdAllocationRequest idRangeRequest, WritableChannel channel) throws IOException {
        new MemberId.Marshal().marshal(idRangeRequest.owner(), channel);
        channel.putInt(idRangeRequest.idType().ordinal());
        channel.putLong(idRangeRequest.idRangeStart());
        channel.putInt(idRangeRequest.idRangeLength());
    }

    public static ReplicatedIdAllocationRequest unmarshal(ReadableChannel channel) throws IOException, EndOfStreamException {
        MemberId owner = (MemberId)new MemberId.Marshal().unmarshal(channel);
        IdType idType = IdType.values()[channel.getInt()];
        long idRangeStart = channel.getLong();
        int idRangeLength = channel.getInt();
        return new ReplicatedIdAllocationRequest(owner, idType, idRangeStart, idRangeLength);
    }
}

