/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.id;

import org.neo4j.causalclustering.core.state.machines.id.IdAllocation;
import org.neo4j.causalclustering.core.state.machines.id.IdRangeIterator;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdRangeAcquirer;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdRange;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

class ReplicatedIdGenerator
implements IdGenerator {
    private final IdType idType;
    private final Log log;
    private final ReplicatedIdRangeAcquirer acquirer;
    private volatile long highId;
    private volatile long defragCount;
    private volatile IdRangeIterator idQueue = IdRangeIterator.EMPTY_ID_RANGE_ITERATOR;

    ReplicatedIdGenerator(IdType idType, long highId, ReplicatedIdRangeAcquirer acquirer, LogProvider logProvider) {
        this.idType = idType;
        this.highId = highId;
        this.acquirer = acquirer;
        this.log = logProvider.getLog(this.getClass());
    }

    public void close() {
    }

    public void freeId(long id) {
    }

    public long getHighId() {
        return this.highId;
    }

    public void setHighId(long id) {
        this.highId = Math.max(this.highId, id);
    }

    public long getHighestPossibleIdInUse() {
        return this.highId - 1L;
    }

    public long getNumberOfIdsInUse() {
        return this.highId - this.defragCount;
    }

    public synchronized long nextId() {
        long nextId = this.idQueue.next();
        if (nextId == -1L) {
            IdAllocation allocation = this.acquirer.acquireIds(this.idType);
            assert (allocation.getIdRange().getRangeLength() > 0);
            this.log.debug("Received id allocation " + allocation + " for " + this.idType);
            nextId = this.storeLocally(allocation);
        }
        this.highId = Math.max(this.highId, nextId + 1L);
        return nextId;
    }

    public IdRange nextIdBatch(int size) {
        throw new UnsupportedOperationException("Should never be called");
    }

    private long storeLocally(IdAllocation allocation) {
        this.setHighId(allocation.getHighestIdInUse() + 1L);
        this.defragCount = allocation.getDefragCount();
        this.idQueue = new IdRangeIterator(this.respectingHighId(allocation.getIdRange()));
        return this.idQueue.next();
    }

    private IdRange respectingHighId(IdRange idRange) {
        int adjustment = 0;
        long originalRangeStart = idRange.getRangeStart();
        if (this.highId > originalRangeStart) {
            adjustment = (int)(this.highId - originalRangeStart);
        }
        long rangeStart = Math.max(this.highId, originalRangeStart);
        int rangeLength = idRange.getRangeLength() - adjustment;
        if (rangeLength <= 0) {
            throw new IllegalStateException("IdAllocation state is probably corrupted or out of sync with the cluster. Local highId is " + this.highId + " and allocation range is " + idRange);
        }
        return new IdRange(idRange.getDefragIds(), rangeStart, rangeLength);
    }

    public long getDefragCount() {
        return this.defragCount;
    }

    public void delete() {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.idQueue + "]";
    }
}

