/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.locks;

import java.io.IOException;
import java.util.function.Consumer;
import org.neo4j.causalclustering.core.state.Result;
import org.neo4j.causalclustering.core.state.machines.StateMachine;
import org.neo4j.causalclustering.core.state.machines.locks.LockToken;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenRequest;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenState;
import org.neo4j.causalclustering.core.state.storage.StateStorage;

public class ReplicatedLockTokenStateMachine
implements StateMachine<ReplicatedLockTokenRequest> {
    private final StateStorage<ReplicatedLockTokenState> storage;
    private ReplicatedLockTokenState state;

    public ReplicatedLockTokenStateMachine(StateStorage<ReplicatedLockTokenState> storage) {
        this.storage = storage;
    }

    @Override
    public synchronized void applyCommand(ReplicatedLockTokenRequest tokenRequest, long commandIndex, Consumer<Result> callback) {
        boolean requestAccepted;
        if (commandIndex <= this.state().ordinal()) {
            return;
        }
        boolean bl = requestAccepted = tokenRequest.id() == LockToken.nextCandidateId(this.currentToken().id());
        if (requestAccepted) {
            this.state().set(tokenRequest, commandIndex);
        }
        callback.accept(Result.of(requestAccepted));
    }

    @Override
    public synchronized void flush() throws IOException {
        this.storage.persistStoreData(this.state());
    }

    @Override
    public long lastAppliedIndex() {
        return this.state().ordinal();
    }

    private ReplicatedLockTokenState state() {
        if (this.state == null) {
            this.state = this.storage.getInitialState();
        }
        return this.state;
    }

    public synchronized ReplicatedLockTokenState snapshot() {
        return this.state().newInstance();
    }

    public synchronized void installSnapshot(ReplicatedLockTokenState snapshot) {
        this.state = snapshot;
    }

    public synchronized ReplicatedLockTokenRequest currentToken() {
        return this.state().get();
    }
}

