/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.token;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.neo4j.causalclustering.core.consensus.NoLeaderFoundException;
import org.neo4j.causalclustering.core.replication.Replicator;
import org.neo4j.causalclustering.core.state.machines.token.ReplicatedTokenRequest;
import org.neo4j.causalclustering.core.state.machines.token.ReplicatedTokenRequestSerializer;
import org.neo4j.causalclustering.core.state.machines.token.TokenRegistry;
import org.neo4j.causalclustering.core.state.machines.token.TokenType;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationKernelException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.core.NonUniqueTokenException;
import org.neo4j.kernel.impl.core.TokenHolder;
import org.neo4j.kernel.impl.core.TokenNotFoundException;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.Token;
import org.neo4j.storageengine.api.lock.ResourceLocker;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;

abstract class ReplicatedTokenHolder<TOKEN extends Token>
implements TokenHolder<TOKEN> {
    protected final Dependencies dependencies;
    private final Replicator replicator;
    private final TokenRegistry<TOKEN> tokenRegistry;
    private final IdGeneratorFactory idGeneratorFactory;
    private final IdType tokenIdType;
    private final TokenType type;

    ReplicatedTokenHolder(TokenRegistry<TOKEN> tokenRegistry, Replicator replicator, IdGeneratorFactory idGeneratorFactory, IdType tokenIdType, Dependencies dependencies, TokenType type) {
        this.replicator = replicator;
        this.tokenRegistry = tokenRegistry;
        this.idGeneratorFactory = idGeneratorFactory;
        this.tokenIdType = tokenIdType;
        this.type = type;
        this.dependencies = dependencies;
    }

    public void setInitialTokens(List<TOKEN> tokens) throws NonUniqueTokenException {
        this.tokenRegistry.setInitialTokens(tokens);
    }

    public void addToken(TOKEN token) throws NonUniqueTokenException {
        this.tokenRegistry.addToken(token);
    }

    public int getOrCreateId(String tokenName) {
        Integer tokenId = this.tokenRegistry.getId(tokenName);
        if (tokenId != null) {
            return tokenId;
        }
        return this.requestToken(tokenName);
    }

    private int requestToken(String tokenName) {
        ReplicatedTokenRequest tokenRequest = new ReplicatedTokenRequest(this.type, tokenName, this.createCommands(tokenName));
        try {
            Future<Object> future = this.replicator.replicate(tokenRequest, true);
            return (Integer)future.get();
        }
        catch (InterruptedException | NoLeaderFoundException e) {
            throw new TransactionFailureException("Could not create token", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    private byte[] createCommands(String tokenName) {
        StorageEngine storageEngine = (StorageEngine)this.dependencies.resolveDependency(StorageEngine.class);
        ArrayList<StorageCommand> commands = new ArrayList<StorageCommand>();
        TxState txState = new TxState();
        int tokenId = Math.toIntExact(this.idGeneratorFactory.get(this.tokenIdType).nextId());
        this.createToken((TransactionState)txState, tokenName, tokenId);
        try (StorageStatement statement = storageEngine.storeReadLayer().newStatement();){
            storageEngine.createCommands(commands, (ReadableTransactionState)txState, statement, ResourceLocker.NONE, Long.MAX_VALUE);
        }
        catch (org.neo4j.kernel.api.exceptions.TransactionFailureException | ConstraintValidationKernelException | CreateConstraintFailureException e) {
            throw new RuntimeException("Unable to create token '" + tokenName + "'", e);
        }
        return ReplicatedTokenRequestSerializer.commandBytes(commands);
    }

    protected abstract void createToken(TransactionState var1, String var2, int var3);

    public TOKEN getTokenById(int id) throws TokenNotFoundException {
        TOKEN result = this.getTokenByIdOrNull(id);
        if (result == null) {
            throw new TokenNotFoundException("Token for id " + id);
        }
        return result;
    }

    public TOKEN getTokenByIdOrNull(int id) {
        return this.tokenRegistry.getToken(id);
    }

    public int getIdByName(String name) {
        Integer id = this.tokenRegistry.getId(name);
        if (id == null) {
            return -1;
        }
        return id;
    }

    public Iterable<TOKEN> getAllTokens() {
        return this.tokenRegistry.allTokens();
    }

    public int size() {
        return this.tokenRegistry.size();
    }
}

