/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.token;

import java.util.List;
import org.neo4j.kernel.impl.core.InMemoryTokenCache;
import org.neo4j.storageengine.api.Token;

public class TokenRegistry<TOKEN extends Token> {
    private final InMemoryTokenCache<TOKEN> tokenCache;
    private final String tokenType;

    public TokenRegistry(String tokenType) {
        this.tokenType = tokenType;
        this.tokenCache = new InMemoryTokenCache(tokenType);
    }

    void setInitialTokens(List<TOKEN> tokens) {
        this.tokenCache.clear();
        this.tokenCache.putAll(tokens);
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public int size() {
        return this.tokenCache.size();
    }

    Iterable<TOKEN> allTokens() {
        return this.tokenCache.allTokens();
    }

    Integer getId(String name) {
        return this.tokenCache.getId(name);
    }

    TOKEN getToken(int id) {
        return (TOKEN)this.tokenCache.getToken(id);
    }

    void addToken(TOKEN token) {
        this.tokenCache.put(token);
    }
}

