/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.tx;

import org.neo4j.causalclustering.core.state.machines.tx.LogIndexTxHeaderEncoding;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class LastCommittedIndexFinder {
    private final TransactionIdStore transactionIdStore;
    private final LogicalTransactionStore transactionStore;
    private final Log log;

    public LastCommittedIndexFinder(TransactionIdStore transactionIdStore, LogicalTransactionStore transactionStore, LogProvider logProvider) {
        this.transactionIdStore = transactionIdStore;
        this.transactionStore = transactionStore;
        this.log = logProvider.getLog(this.getClass());
    }

    public long getLastCommittedIndex() {
        long lastTxId = this.transactionIdStore.getLastCommittedTransactionId();
        byte[] lastHeaderFound = null;
        try (TransactionCursor transactions = this.transactionStore.getTransactions(lastTxId);){
            while (transactions.next()) {
                CommittedTransactionRepresentation committedTransactionRepresentation = (CommittedTransactionRepresentation)transactions.get();
                lastHeaderFound = committedTransactionRepresentation.getStartEntry().getAdditionalHeader();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (lastHeaderFound == null) {
            throw new RuntimeException("We must have at least one transaction telling us where we are at in the consensus log.");
        }
        long lastCommittedIndex = LogIndexTxHeaderEncoding.decodeLogIndexFromTxHeader(lastHeaderFound);
        this.log.info("Last committed index %d", new Object[]{lastCommittedIndex});
        return lastCommittedIndex;
    }
}

