/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.snapshot;

import java.util.concurrent.CompletableFuture;
import org.neo4j.causalclustering.catchup.CatchUpClient;
import org.neo4j.causalclustering.catchup.CatchUpResponseAdaptor;
import org.neo4j.causalclustering.catchup.CatchupResult;
import org.neo4j.causalclustering.catchup.storecopy.LocalDatabase;
import org.neo4j.causalclustering.catchup.storecopy.RemoteStore;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFailedException;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyProcess;
import org.neo4j.causalclustering.core.state.CoreState;
import org.neo4j.causalclustering.core.state.machines.CoreStateMachines;
import org.neo4j.causalclustering.core.state.snapshot.CoreSnapshot;
import org.neo4j.causalclustering.core.state.snapshot.CoreSnapshotRequest;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class CoreStateDownloader {
    private final LocalDatabase localDatabase;
    private final Lifecycle startStopOnStoreCopy;
    private final RemoteStore remoteStore;
    private final CatchUpClient catchUpClient;
    private final Log log;
    private final StoreCopyProcess storeCopyProcess;
    private final CoreStateMachines coreStateMachines;

    public CoreStateDownloader(LocalDatabase localDatabase, Lifecycle startStopOnStoreCopy, RemoteStore remoteStore, CatchUpClient catchUpClient, LogProvider logProvider, StoreCopyProcess storeCopyProcess, CoreStateMachines coreStateMachines) {
        this.localDatabase = localDatabase;
        this.startStopOnStoreCopy = startStopOnStoreCopy;
        this.remoteStore = remoteStore;
        this.catchUpClient = catchUpClient;
        this.log = logProvider.getLog(this.getClass());
        this.storeCopyProcess = storeCopyProcess;
        this.coreStateMachines = coreStateMachines;
    }

    public synchronized void downloadSnapshot(MemberId source, CoreState coreState) throws StoreCopyFailedException {
        try {
            boolean isEmptyStore = this.localDatabase.isEmpty();
            if (!isEmptyStore) {
                this.localDatabase.start();
                this.localDatabase.stop();
            }
            StoreId remoteStoreId = this.remoteStore.getStoreId(source);
            if (!isEmptyStore && !remoteStoreId.equals(this.localDatabase.storeId())) {
                throw new StoreCopyFailedException("StoreId mismatch and not empty");
            }
            this.startStopOnStoreCopy.stop();
            this.localDatabase.stopForStoreCopy();
            this.log.info("Downloading snapshot from core server at %s", new Object[]{source});
            CoreSnapshot coreSnapshot = this.catchUpClient.makeBlockingRequest(source, new CoreSnapshotRequest(), new CatchUpResponseAdaptor<CoreSnapshot>(){

                @Override
                public void onCoreSnapshot(CompletableFuture<CoreSnapshot> signal, CoreSnapshot response) {
                    signal.complete(response);
                }
            });
            if (isEmptyStore) {
                this.storeCopyProcess.replaceWithStoreFrom(source, remoteStoreId);
            } else {
                StoreId localStoreId = this.localDatabase.storeId();
                CatchupResult catchupResult = this.remoteStore.tryCatchingUp(source, localStoreId, this.localDatabase.storeDir());
                if (catchupResult == CatchupResult.E_TRANSACTION_PRUNED) {
                    this.log.info("Failed to pull transactions from " + source + ". They may have been pruned away.");
                    this.localDatabase.delete();
                    this.storeCopyProcess.replaceWithStoreFrom(source, localStoreId);
                } else if (catchupResult != CatchupResult.SUCCESS_END_OF_STREAM) {
                    throw new StoreCopyFailedException("Failed to download store: " + (Object)((Object)catchupResult));
                }
            }
            coreState.installSnapshot(coreSnapshot);
            this.log.info("Core snapshot installed: " + coreSnapshot);
            this.log.info("Starting local database");
            this.localDatabase.start();
            this.coreStateMachines.installCommitProcess(this.localDatabase.getCommitProcess());
            this.startStopOnStoreCopy.start();
        }
        catch (StoreCopyFailedException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new StoreCopyFailedException(e);
        }
    }
}

