/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.neo4j.causalclustering.discovery.CoreAddresses;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;

public class CoreTopology {
    public static CoreTopology EMPTY = new CoreTopology(null, false, Collections.emptyMap());
    private final ClusterId clusterId;
    private final boolean canBeBootstrapped;
    private final Map<MemberId, CoreAddresses> coreMembers;

    public CoreTopology(ClusterId clusterId, boolean canBeBootstrapped, Map<MemberId, CoreAddresses> coreMembers) {
        this.clusterId = clusterId;
        this.canBeBootstrapped = canBeBootstrapped;
        this.coreMembers = new HashMap<MemberId, CoreAddresses>(coreMembers);
    }

    public Set<MemberId> members() {
        return this.coreMembers.keySet();
    }

    public ClusterId clusterId() {
        return this.clusterId;
    }

    public Collection<CoreAddresses> addresses() {
        return this.coreMembers.values();
    }

    public boolean canBeBootstrapped() {
        return this.canBeBootstrapped;
    }

    public Optional<CoreAddresses> find(MemberId memberId) {
        return Optional.ofNullable(this.coreMembers.get(memberId));
    }

    public String toString() {
        return String.format("{coreMembers=%s, bootstrappable=%s}", this.coreMembers, this.canBeBootstrapped());
    }
}

