/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery.procedures;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.consensus.LeaderLocator;
import org.neo4j.causalclustering.core.consensus.NoLeaderFoundException;
import org.neo4j.causalclustering.discovery.CoreAddresses;
import org.neo4j.causalclustering.discovery.CoreTopologyService;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.collection.RawIterator;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.api.proc.Neo4jTypes;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.api.proc.QualifiedName;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class GetServersProcedure
extends CallableProcedure.BasicProcedure {
    public static final String NAME = "getServers";
    private final CoreTopologyService discoveryService;
    private final LeaderLocator leaderLocator;
    private final Config config;
    private final Log log;

    public GetServersProcedure(CoreTopologyService discoveryService, LeaderLocator leaderLocator, Config config, LogProvider logProvider) {
        super(ProcedureSignature.procedureSignature((QualifiedName)new QualifiedName(new String[]{"dbms", "cluster", "routing"}, NAME)).out("ttl", (Neo4jTypes.AnyType)Neo4jTypes.NTInteger).out("servers", (Neo4jTypes.AnyType)Neo4jTypes.NTMap).description("Provides recommendations about servers that support reads, writes, and can act as routers.").build());
        this.discoveryService = discoveryService;
        this.leaderLocator = leaderLocator;
        this.config = config;
        this.log = logProvider.getLog(((Object)((Object)this)).getClass());
    }

    public RawIterator<Object[], ProcedureException> apply(Context ctx, Object[] input) throws ProcedureException {
        List<ReadWriteRouteEndPoint> writeEndpoints = this.writeEndpoints();
        List<ReadWriteRouteEndPoint> readEndpoints = this.readEndpoints();
        List<ReadWriteRouteEndPoint> routeEndpoints = this.routeEndpoints();
        return this.wrapUpEndpoints(routeEndpoints, writeEndpoints, readEndpoints);
    }

    private Optional<AdvertisedSocketAddress> leaderAdvertisedSocketAddress() {
        MemberId leader;
        try {
            leader = this.leaderLocator.getLeader();
        }
        catch (NoLeaderFoundException e) {
            this.log.debug("No leader server found. This can happen during a leader switch. No write end points available");
            return Optional.empty();
        }
        return this.discoveryService.coreServers().find(leader).map(server -> server.getClientConnectorAddresses().getBoltAddress());
    }

    private List<ReadWriteRouteEndPoint> routeEndpoints() {
        Stream<AdvertisedSocketAddress> routers = this.discoveryService.coreServers().addresses().stream().map(server -> server.getClientConnectorAddresses().getBoltAddress());
        List<ReadWriteRouteEndPoint> routeEndpoints = routers.map(ReadWriteRouteEndPoint::route).collect(Collectors.toList());
        Collections.shuffle(routeEndpoints);
        return routeEndpoints;
    }

    private List<ReadWriteRouteEndPoint> writeEndpoints() {
        return this.leaderAdvertisedSocketAddress().map(ReadWriteRouteEndPoint::write).map(Collections::singletonList).orElse(Collections.emptyList());
    }

    private List<ReadWriteRouteEndPoint> readEndpoints() {
        List readReplicas = this.discoveryService.readReplicas().members().stream().map(server -> server.getClientConnectorAddresses().getBoltAddress()).collect(Collectors.toList());
        boolean addFollowers = readReplicas.isEmpty() || (Boolean)this.config.get(CausalClusteringSettings.cluster_allow_reads_on_followers) != false;
        Stream<Object> readCore = addFollowers ? this.coreReadEndPoints() : Stream.empty();
        List<ReadWriteRouteEndPoint> readEndPoints = Stream.concat(readReplicas.stream(), readCore).map(ReadWriteRouteEndPoint::read).collect(Collectors.toList());
        Collections.shuffle(readEndPoints);
        return readEndPoints;
    }

    private Stream<AdvertisedSocketAddress> coreReadEndPoints() {
        Optional<AdvertisedSocketAddress> leader = this.leaderAdvertisedSocketAddress();
        Collection<CoreAddresses> addresses = this.discoveryService.coreServers().addresses();
        Stream<AdvertisedSocketAddress> allAddresses = addresses.stream().map(server -> server.getClientConnectorAddresses().getBoltAddress());
        if (leader.isPresent() && addresses.size() > 1) {
            AdvertisedSocketAddress advertisedSocketAddress = leader.get();
            return allAddresses.filter(address -> !advertisedSocketAddress.equals(address));
        }
        return allAddresses;
    }

    private RawIterator<Object[], ProcedureException> wrapUpEndpoints(List<ReadWriteRouteEndPoint> routeEndpoints, List<ReadWriteRouteEndPoint> writeEndpoints, List<ReadWriteRouteEndPoint> readEndpoints) {
        TreeMap<String, Object> map;
        Object[] routers = routeEndpoints.stream().map(ReadWriteRouteEndPoint::address).toArray();
        Object[] readers = readEndpoints.stream().map(ReadWriteRouteEndPoint::address).toArray();
        Object[] writers = writeEndpoints.stream().map(ReadWriteRouteEndPoint::address).toArray();
        ArrayList servers = new ArrayList();
        if (writers.length > 0) {
            map = new TreeMap<String, Object>();
            map.put("role", Type.WRITE.name());
            map.put("addresses", writers);
            servers.add(map);
        }
        if (readers.length > 0) {
            map = new TreeMap();
            map.put("role", Type.READ.name());
            map.put("addresses", readers);
            servers.add(map);
        }
        if (routers.length > 0) {
            map = new TreeMap();
            map.put("role", Type.ROUTE.name());
            map.put("addresses", routers);
            servers.add(map);
        }
        long ttl = TimeUnit.MILLISECONDS.toSeconds((Long)this.config.get(CausalClusteringSettings.cluster_routing_ttl));
        Object[] row = new Object[]{ttl, servers};
        return RawIterator.of((Object[])new Object[][]{row});
    }

    private static class ReadWriteRouteEndPoint {
        private final AdvertisedSocketAddress address;
        private final Type type;

        public String address() {
            return this.address.toString();
        }

        public String type() {
            return this.type.toString().toUpperCase();
        }

        ReadWriteRouteEndPoint(AdvertisedSocketAddress address, Type type) {
            this.address = address;
            this.type = type;
        }

        public static ReadWriteRouteEndPoint write(AdvertisedSocketAddress address) {
            return new ReadWriteRouteEndPoint(address, Type.WRITE);
        }

        public static ReadWriteRouteEndPoint read(AdvertisedSocketAddress address) {
            return new ReadWriteRouteEndPoint(address, Type.READ);
        }

        static ReadWriteRouteEndPoint route(AdvertisedSocketAddress address) {
            return new ReadWriteRouteEndPoint(address, Type.ROUTE);
        }

        public String toString() {
            return "ReadWriteRouteEndPoint{address=" + this.address + ", type=" + (Object)((Object)this.type) + '}';
        }
    }

    public static enum Type {
        READ,
        WRITE,
        ROUTE;

    }
}

