/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging;

import java.util.Optional;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.discovery.CoreAddresses;
import org.neo4j.causalclustering.discovery.CoreTopologyService;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.ClusterIdentity;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.Message;
import org.neo4j.causalclustering.messaging.Outbound;
import org.neo4j.causalclustering.messaging.address.UnknownAddressMonitor;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.time.Clocks;

public class RaftOutbound
implements Outbound<MemberId, RaftMessages.RaftMessage> {
    private final CoreTopologyService discoveryService;
    private final Outbound<AdvertisedSocketAddress, Message> outbound;
    private final ClusterIdentity clusterIdentity;
    private final UnknownAddressMonitor unknownAddressMonitor;
    private final Log log;

    public RaftOutbound(CoreTopologyService discoveryService, Outbound<AdvertisedSocketAddress, Message> outbound, ClusterIdentity clusterIdentity, LogProvider logProvider, long logThresholdMillis) {
        this.discoveryService = discoveryService;
        this.outbound = outbound;
        this.clusterIdentity = clusterIdentity;
        this.log = logProvider.getLog(this.getClass());
        this.unknownAddressMonitor = new UnknownAddressMonitor(this.log, Clocks.systemClock(), logThresholdMillis);
    }

    @Override
    public void send(MemberId to, RaftMessages.RaftMessage message) {
        ClusterId clusterId = this.clusterIdentity.clusterId();
        if (clusterId == null) {
            this.log.warn("Attempting to send a message before bound to a cluster");
            return;
        }
        Optional<CoreAddresses> coreAddresses = this.discoveryService.coreServers().find(to);
        if (coreAddresses.isPresent()) {
            this.outbound.send(coreAddresses.get().getRaftServer(), new RaftMessages.ClusterIdAwareMessage(clusterId, message));
        } else {
            this.unknownAddressMonitor.logAttemptToSendToMemberWithNoKnownAddress(to);
        }
    }
}

