/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.neo4j.causalclustering.catchup.CatchUpProtocolViolationException;
import org.neo4j.causalclustering.catchup.CatchUpResponseCallback;
import org.neo4j.causalclustering.catchup.storecopy.FileChunk;
import org.neo4j.causalclustering.catchup.storecopy.FileHeader;
import org.neo4j.causalclustering.catchup.storecopy.GetStoreIdResponse;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFinishedResponse;
import org.neo4j.causalclustering.catchup.tx.TxPullResponse;
import org.neo4j.causalclustering.catchup.tx.TxStreamFinishedResponse;
import org.neo4j.causalclustering.core.state.snapshot.CoreSnapshot;

public class CatchUpResponseAdaptor<T>
implements CatchUpResponseCallback<T> {
    @Override
    public void onFileHeader(CompletableFuture<T> signal, FileHeader response) {
        signal.completeExceptionally(new CatchUpProtocolViolationException("Unexpected response: %s", response));
    }

    @Override
    public boolean onFileContent(CompletableFuture<T> signal, FileChunk response) throws IOException {
        signal.completeExceptionally(new CatchUpProtocolViolationException("Unexpected response: %s", response));
        return false;
    }

    @Override
    public void onFileStreamingComplete(CompletableFuture<T> signal, StoreCopyFinishedResponse response) {
        signal.completeExceptionally(new CatchUpProtocolViolationException("Unexpected response: %s", response));
    }

    @Override
    public void onTxPullResponse(CompletableFuture<T> signal, TxPullResponse response) {
        signal.completeExceptionally(new CatchUpProtocolViolationException("Unexpected response: %s", response));
    }

    @Override
    public void onTxStreamFinishedResponse(CompletableFuture<T> signal, TxStreamFinishedResponse response) {
        signal.completeExceptionally(new CatchUpProtocolViolationException("Unexpected response: %s", response));
    }

    @Override
    public void onGetStoreIdResponse(CompletableFuture<T> signal, GetStoreIdResponse response) {
        signal.completeExceptionally(new CatchUpProtocolViolationException("Unexpected response: %s", response));
    }

    @Override
    public void onCoreSnapshot(CompletableFuture<T> signal, CoreSnapshot response) {
        signal.completeExceptionally(new CatchUpProtocolViolationException("Unexpected response: %s", response));
    }
}

