/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup;

import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.neo4j.causalclustering.catchup.CatchUpClientException;
import org.neo4j.logging.Log;

class TimeoutLoop {
    TimeoutLoop() {
    }

    static <T> T waitForCompletion(Future<T> future, String operation, Supplier<Optional<Long>> millisSinceLastResponseSupplier, long inactivityTimeoutMillis, Log log) throws CatchUpClientException {
        long remainingTimeoutMillis = inactivityTimeoutMillis;
        while (true) {
            try {
                return future.get(remainingTimeoutMillis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw TimeoutLoop.exception(future, operation, e);
            }
            catch (ExecutionException e) {
                throw TimeoutLoop.exception(future, operation, e);
            }
            catch (TimeoutException e) {
                if (!millisSinceLastResponseSupplier.get().isPresent()) {
                    log.info("Request timed out with no responses after " + inactivityTimeoutMillis + " ms.");
                    throw TimeoutLoop.exception(future, operation, e);
                }
                long millisSinceLastResponse = millisSinceLastResponseSupplier.get().get();
                if (millisSinceLastResponse < inactivityTimeoutMillis) {
                    remainingTimeoutMillis = inactivityTimeoutMillis - millisSinceLastResponse;
                    continue;
                }
                log.info("Request timed out after period of inactivity. Time since last response: " + millisSinceLastResponse + " ms.");
                throw TimeoutLoop.exception(future, operation, e);
            }
            break;
        }
    }

    private static CatchUpClientException exception(Future<?> future, String operation, Exception e) {
        future.cancel(true);
        return new CatchUpClientException(operation, e);
    }
}

