/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.io.File;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFailedException;
import org.neo4j.com.storecopy.ExternallyManagedPageCache;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Exceptions;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.storemigration.UpgradeNotAllowedByConfigurationException;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class CopiedStoreRecovery
extends LifecycleAdapter {
    private final Config config;
    private final Iterable<KernelExtensionFactory<?>> kernelExtensions;
    private final PageCache pageCache;
    private boolean shutdown;

    public CopiedStoreRecovery(Config config, Iterable<KernelExtensionFactory<?>> kernelExtensions, PageCache pageCache) {
        this.config = config;
        this.kernelExtensions = kernelExtensions;
        this.pageCache = pageCache;
    }

    public synchronized void shutdown() {
        this.shutdown = true;
    }

    public synchronized void recoverCopiedStore(File tempStore) throws StoreCopyFailedException {
        if (this.shutdown) {
            throw new StoreCopyFailedException("Abort store-copied store recovery due to database shutdown");
        }
        try {
            GraphDatabaseService graphDatabaseService = this.newTempDatabase(tempStore);
            graphDatabaseService.shutdown();
        }
        catch (Exception e) {
            Throwable peeled = Exceptions.peel((Throwable)e, t -> !(t instanceof UpgradeNotAllowedByConfigurationException));
            if (peeled != null) {
                throw new RuntimeException(this.failedToStartMessage(), e);
            }
            throw e;
        }
    }

    private String failedToStartMessage() {
        String recordFormat = (String)this.config.get(GraphDatabaseSettings.record_format);
        return String.format("Failed to start database with copied store. This may be because the core servers and read replicas have a different record format. On this machine: `%s=%s`. Check the equivalent value on the core server.", GraphDatabaseSettings.record_format.name(), recordFormat);
    }

    private GraphDatabaseService newTempDatabase(File tempStore) {
        return ExternallyManagedPageCache.graphDatabaseFactoryWithPageCache((PageCache)this.pageCache).setKernelExtensions(this.kernelExtensions).setUserLogProvider((LogProvider)NullLogProvider.getInstance()).newEmbeddedDatabaseBuilder(tempStore).setConfig(GraphDatabaseSettings.label_index, GraphDatabaseSettings.LabelIndex.AUTO.name()).setConfig("dbms.backup.enabled", "false").setConfig(GraphDatabaseSettings.logs_directory, tempStore.getAbsolutePath()).setConfig(GraphDatabaseSettings.keep_logical_logs, "true").setConfig(GraphDatabaseSettings.allow_store_upgrade, ((Boolean)this.config.get(GraphDatabaseSettings.allow_store_upgrade)).toString()).setConfig(GraphDatabaseSettings.record_format, (String)this.config.get(GraphDatabaseSettings.record_format)).newGraphDatabase();
    }
}

