/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.neo4j.causalclustering.catchup.CatchUpResponseHandler;
import org.neo4j.causalclustering.catchup.CatchupClientProtocol;
import org.neo4j.causalclustering.catchup.storecopy.FileHeader;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class FileHeaderHandler
extends SimpleChannelInboundHandler<FileHeader> {
    private final CatchupClientProtocol protocol;
    private final CatchUpResponseHandler handler;
    private final Log log;

    public FileHeaderHandler(CatchupClientProtocol protocol, CatchUpResponseHandler handler, LogProvider logProvider) {
        this.protocol = protocol;
        this.handler = handler;
        this.log = logProvider.getLog(((Object)((Object)this)).getClass());
    }

    protected void channelRead0(ChannelHandlerContext ctx, FileHeader fileHeader) throws Exception {
        this.log.info("Receiving file: %s", new Object[]{fileHeader.fileName()});
        this.handler.onFileHeader(fileHeader);
        this.protocol.expect(CatchupClientProtocol.State.FILE_CONTENTS);
    }
}

