/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.neo4j.causalclustering.catchup.storecopy.StoreFiles;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionRepresentationCommitProcess;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.storemigration.StoreFile;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.kernel.impl.util.watcher.FileSystemWatcherService;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.StorageEngine;

public class LocalDatabase
implements Lifecycle {
    private static final AvailabilityGuard.AvailabilityRequirement NOT_STOPPED = AvailabilityGuard.availabilityRequirement((String)"Database is stopped");
    private static final AvailabilityGuard.AvailabilityRequirement NOT_COPYING_STORE = AvailabilityGuard.availabilityRequirement((String)"Database is stopped to copy store from another cluster member");
    private final File storeDir;
    private final StoreFiles storeFiles;
    private final DataSourceManager dataSourceManager;
    private final Supplier<DatabaseHealth> databaseHealthSupplier;
    private final AvailabilityGuard availabilityGuard;
    private final Log log;
    private final FileSystemWatcherService watcherService;
    private volatile StoreId storeId;
    private volatile DatabaseHealth databaseHealth;
    private volatile AvailabilityGuard.AvailabilityRequirement currentRequirement;
    private volatile TransactionCommitProcess localCommit;

    public LocalDatabase(File storeDir, StoreFiles storeFiles, DataSourceManager dataSourceManager, Supplier<DatabaseHealth> databaseHealthSupplier, FileSystemWatcherService watcherService, AvailabilityGuard availabilityGuard, LogProvider logProvider) {
        this.storeDir = storeDir;
        this.storeFiles = storeFiles;
        this.dataSourceManager = dataSourceManager;
        this.databaseHealthSupplier = databaseHealthSupplier;
        this.availabilityGuard = availabilityGuard;
        this.watcherService = watcherService;
        this.log = logProvider.getLog(this.getClass());
        this.raiseAvailabilityGuard(NOT_STOPPED);
    }

    public void init() throws Throwable {
        this.dataSourceManager.init();
        this.watcherService.init();
    }

    public synchronized void start() throws Throwable {
        if (this.isAvailable()) {
            return;
        }
        this.storeId = this.readStoreIdFromDisk();
        this.log.info("Starting with storeId: " + this.storeId);
        this.dataSourceManager.start();
        this.watcherService.start();
        this.dropAvailabilityGuard();
    }

    public void stop() throws Throwable {
        this.stopWithRequirement(NOT_STOPPED);
    }

    public void stopForStoreCopy() throws Throwable {
        this.stopWithRequirement(NOT_COPYING_STORE);
    }

    public boolean isAvailable() {
        return this.currentRequirement == null;
    }

    public void shutdown() throws Throwable {
        this.watcherService.shutdown();
        this.dataSourceManager.shutdown();
    }

    public synchronized StoreId storeId() {
        if (this.isAvailable()) {
            return this.storeId;
        }
        return this.readStoreIdFromDisk();
    }

    private StoreId readStoreIdFromDisk() {
        try {
            return this.storeFiles.readStoreId(this.storeDir);
        }
        catch (IOException e) {
            this.log.error("Failure reading store id", (Throwable)e);
            return null;
        }
    }

    public void panic(Throwable cause) {
        this.getDatabaseHealth().panic(cause);
    }

    public <EXCEPTION extends Throwable> void assertHealthy(Class<EXCEPTION> cause) throws EXCEPTION {
        this.getDatabaseHealth().assertHealthy(cause);
    }

    private DatabaseHealth getDatabaseHealth() {
        if (this.databaseHealth == null) {
            this.databaseHealth = this.databaseHealthSupplier.get();
        }
        return this.databaseHealth;
    }

    public void delete() throws IOException {
        this.storeFiles.delete(this.storeDir);
    }

    public boolean isEmpty() throws IOException {
        List<File> filesToLookFor = Arrays.stream(StoreType.values()).map(StoreType::getStoreFile).filter(Objects::nonNull).map(StoreFile::storeFileName).map(name -> new File(this.storeDir, (String)name)).collect(Collectors.toList());
        return this.storeFiles.isEmpty(this.storeDir, filesToLookFor);
    }

    public File storeDir() {
        return this.storeDir;
    }

    void replaceWith(File sourceDir) throws IOException {
        this.storeFiles.delete(this.storeDir);
        this.storeFiles.moveTo(sourceDir, this.storeDir);
    }

    public NeoStoreDataSource dataSource() {
        return this.dataSourceManager.getDataSource();
    }

    public void registerCommitProcessDependencies(TransactionAppender appender, StorageEngine applier) {
        this.localCommit = new TransactionRepresentationCommitProcess(appender, applier);
    }

    public TransactionCommitProcess getCommitProcess() {
        return this.localCommit;
    }

    private synchronized void stopWithRequirement(AvailabilityGuard.AvailabilityRequirement requirement) throws Throwable {
        this.log.info("Stopping, reason: " + requirement.description());
        this.raiseAvailabilityGuard(requirement);
        this.databaseHealth = null;
        this.localCommit = null;
        this.watcherService.stop();
        this.dataSourceManager.stop();
    }

    private void raiseAvailabilityGuard(AvailabilityGuard.AvailabilityRequirement requirement) {
        this.availabilityGuard.require(requirement);
        if (this.currentRequirement != null) {
            this.dropAvailabilityGuard();
        }
        this.currentRequirement = requirement;
    }

    private void dropAvailabilityGuard() {
        this.availabilityGuard.fulfill(this.currentRequirement);
        this.currentRequirement = null;
    }
}

