/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.neo4j.causalclustering.catchup.CatchUpClient;
import org.neo4j.causalclustering.catchup.CatchUpClientException;
import org.neo4j.causalclustering.catchup.CatchUpResponseAdaptor;
import org.neo4j.causalclustering.catchup.storecopy.FileChunk;
import org.neo4j.causalclustering.catchup.storecopy.FileHeader;
import org.neo4j.causalclustering.catchup.storecopy.GetStoreIdRequest;
import org.neo4j.causalclustering.catchup.storecopy.GetStoreIdResponse;
import org.neo4j.causalclustering.catchup.storecopy.GetStoreRequest;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFailedException;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFinishedResponse;
import org.neo4j.causalclustering.catchup.storecopy.StoreFileStreams;
import org.neo4j.causalclustering.catchup.storecopy.StoreIdDownloadFailedException;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class StoreCopyClient {
    private final CatchUpClient catchUpClient;
    private final Log log;

    public StoreCopyClient(CatchUpClient catchUpClient, LogProvider logProvider) {
        this.catchUpClient = catchUpClient;
        this.log = logProvider.getLog(this.getClass());
    }

    long copyStoreFiles(MemberId from, StoreId expectedStoreId, final StoreFileStreams storeFileStreams) throws StoreCopyFailedException {
        try {
            return this.catchUpClient.makeBlockingRequest(from, new GetStoreRequest(expectedStoreId), new CatchUpResponseAdaptor<Long>(){
                private String destination;
                private int requiredAlignment;

                @Override
                public void onFileHeader(CompletableFuture<Long> requestOutcomeSignal, FileHeader fileHeader) {
                    this.destination = fileHeader.fileName();
                    this.requiredAlignment = fileHeader.requiredAlignment();
                }

                @Override
                public boolean onFileContent(CompletableFuture<Long> signal, FileChunk fileChunk) throws IOException {
                    storeFileStreams.write(this.destination, this.requiredAlignment, fileChunk.bytes());
                    return fileChunk.isLast();
                }

                @Override
                public void onFileStreamingComplete(CompletableFuture<Long> signal, StoreCopyFinishedResponse response) {
                    StoreCopyClient.this.log.info("Finished streaming %s", new Object[]{this.destination});
                    signal.complete(response.lastCommittedTxBeforeStoreCopy());
                }
            });
        }
        catch (CatchUpClientException e) {
            throw new StoreCopyFailedException(e);
        }
    }

    StoreId fetchStoreId(MemberId from) throws StoreIdDownloadFailedException {
        try {
            CatchUpResponseAdaptor<StoreId> responseHandler = new CatchUpResponseAdaptor<StoreId>(){

                @Override
                public void onGetStoreIdResponse(CompletableFuture<StoreId> signal, GetStoreIdResponse response) {
                    signal.complete(response.storeId());
                }
            };
            return this.catchUpClient.makeBlockingRequest(from, new GetStoreIdRequest(), responseHandler);
        }
        catch (CatchUpClientException e) {
            throw new StoreIdDownloadFailedException(e);
        }
    }
}

