/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.causalclustering.catchup.storecopy.StoreFileStreams;
import org.neo4j.causalclustering.catchup.tx.FileCopyMonitor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.monitoring.Monitors;

class StreamToDisk
implements StoreFileStreams {
    private final File storeDir;
    private final FileSystemAbstraction fs;
    private final PageCache pageCache;
    private final FileCopyMonitor fileCopyMonitor;
    private final Map<String, WritableByteChannel> channels;
    private final Map<String, PagedFile> pagedFiles;

    StreamToDisk(File storeDir, FileSystemAbstraction fs, PageCache pageCache, Monitors monitors) throws IOException {
        this.storeDir = storeDir;
        this.fs = fs;
        this.pageCache = pageCache;
        fs.mkdirs(storeDir);
        this.fileCopyMonitor = (FileCopyMonitor)monitors.newMonitor(FileCopyMonitor.class, new String[0]);
        this.channels = new HashMap<String, WritableByteChannel>();
        this.pagedFiles = new HashMap<String, PagedFile>();
    }

    @Override
    public void write(String destination, int requiredAlignment, byte[] data) throws IOException {
        File fileName = new File(this.storeDir, destination);
        this.fs.mkdirs(fileName.getParentFile());
        this.fileCopyMonitor.copyFile(fileName);
        if (StoreType.shouldBeManagedByPageCache((String)destination)) {
            WritableByteChannel channel = this.channels.get(destination);
            if (channel == null) {
                int filePageSize = this.pageCache.pageSize() - this.pageCache.pageSize() % requiredAlignment;
                PagedFile pagedFile = this.pageCache.map(fileName, filePageSize, new OpenOption[]{StandardOpenOption.CREATE});
                channel = pagedFile.openWritableByteChannel();
                this.pagedFiles.put(destination, pagedFile);
                this.channels.put(destination, channel);
            }
            ByteBuffer buffer = ByteBuffer.wrap(data);
            while (buffer.hasRemaining()) {
                channel.write(buffer);
            }
        } else {
            try (OutputStream outputStream = this.fs.openAsOutputStream(fileName, true);){
                outputStream.write(data);
            }
        }
    }

    @Override
    public void close() throws IOException {
        for (WritableByteChannel channel : this.channels.values()) {
            channel.close();
        }
        for (PagedFile pagedFile : this.pagedFiles.values()) {
            pagedFile.close();
        }
    }
}

