/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.io.File;
import java.io.IOException;
import org.neo4j.causalclustering.catchup.storecopy.StoreFiles;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;

public class TemporaryStoreDirectory
implements AutoCloseable {
    private static final String TEMP_COPY_DIRECTORY_NAME = "temp-copy";
    private final File tempStoreDir;
    private final StoreFiles storeFiles;

    public TemporaryStoreDirectory(FileSystemAbstraction fs, PageCache pageCache, File parent) throws IOException {
        this.tempStoreDir = new File(parent, TEMP_COPY_DIRECTORY_NAME);
        this.storeFiles = new StoreFiles(fs, pageCache, (directory, name) -> true);
        this.storeFiles.delete(this.tempStoreDir);
    }

    public File storeDir() {
        return this.tempStoreDir;
    }

    @Override
    public void close() throws IOException {
        this.storeFiles.delete(this.tempStoreDir);
    }
}

