/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.tx;

import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.impl.api.TransactionRepresentationCommitProcess;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.TransactionApplicationMode;

public class TransactionApplier {
    private final TransactionRepresentationCommitProcess commitProcess;

    public TransactionApplier(DependencyResolver resolver) {
        this.commitProcess = new TransactionRepresentationCommitProcess((TransactionAppender)resolver.resolveDependency(TransactionAppender.class), (StorageEngine)resolver.resolveDependency(StorageEngine.class));
    }

    public void appendToLogAndApplyToStore(CommittedTransactionRepresentation tx) throws TransactionFailureException {
        this.commitProcess.commit(new TransactionToApply(tx.getTransactionRepresentation(), tx.getCommitEntry().getTxId()), CommitEvent.NULL, TransactionApplicationMode.EXTERNAL);
    }
}

