/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.tx;

import java.io.File;
import java.io.IOException;
import org.neo4j.causalclustering.catchup.tx.TxPullResponse;
import org.neo4j.causalclustering.catchup.tx.TxPullResponseListener;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;
import org.neo4j.kernel.impl.transaction.log.LogFile;
import org.neo4j.kernel.impl.transaction.log.LogHeaderCache;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.ReadOnlyLogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class TransactionLogCatchUpWriter
implements TxPullResponseListener,
AutoCloseable {
    private final Lifespan lifespan = new Lifespan(new Lifecycle[0]);
    private final PageCache pageCache;
    private final Log log;
    private final boolean asPartOfStoreCopy;
    private final TransactionLogWriter writer;
    private final PhysicalLogFiles logFiles;
    private final File storeDir;
    private long lastTxId = -1L;
    private long expectedTxId;

    TransactionLogCatchUpWriter(File storeDir, FileSystemAbstraction fs, PageCache pageCache, LogProvider logProvider, long fromTxId, boolean asPartOfStoreCopy) throws IOException {
        this.pageCache = pageCache;
        this.log = logProvider.getLog(this.getClass());
        this.asPartOfStoreCopy = asPartOfStoreCopy;
        this.logFiles = new PhysicalLogFiles(storeDir, fs);
        ReadOnlyLogVersionRepository logVersionRepository = new ReadOnlyLogVersionRepository(pageCache, storeDir);
        LogFile logFile = (LogFile)this.lifespan.add((Lifecycle)new PhysicalLogFile(fs, this.logFiles, Long.MAX_VALUE, () -> fromTxId - 1L, (LogVersionRepository)logVersionRepository, (PhysicalLogFile.Monitor)new Monitors().newMonitor(PhysicalLogFile.Monitor.class, new String[0]), new LogHeaderCache(10)));
        this.writer = new TransactionLogWriter(new LogEntryWriter((FlushableChannel)logFile.getWriter()));
        this.storeDir = storeDir;
        this.expectedTxId = fromTxId;
    }

    @Override
    public synchronized void onTxReceived(TxPullResponse txPullResponse) {
        CommittedTransactionRepresentation tx = txPullResponse.tx();
        long receivedTxId = tx.getCommitEntry().getTxId();
        if (receivedTxId != this.expectedTxId) {
            throw new RuntimeException(String.format("Expected txId: %d but got: %d", this.expectedTxId, receivedTxId));
        }
        this.lastTxId = receivedTxId;
        ++this.expectedTxId;
        try {
            this.writer.append(tx.getTransactionRepresentation(), this.lastTxId);
        }
        catch (IOException e) {
            this.log.error("Failed when appending to transaction log", (Throwable)e);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.asPartOfStoreCopy) {
            long logVersion = this.logFiles.getHighestLogVersion();
            this.writer.checkPoint(new LogPosition(logVersion, 16L));
            File neoStore = new File(this.storeDir, "neostore");
            MetaDataStore.setRecord((PageCache)this.pageCache, (File)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET, (long)16L);
        }
        this.lifespan.close();
        if (this.lastTxId != -1L) {
            File neoStoreFile = new File(this.storeDir, "neostore");
            MetaDataStore.setRecord((PageCache)this.pageCache, (File)neoStoreFile, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_ID, (long)this.lastTxId);
        }
    }
}

