/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.load_balancing.LoadBalancingPluginLoader;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.graphdb.config.SettingValidator;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConfigurationValidator;
import org.neo4j.logging.Log;

public class CausalClusterConfigurationValidator
implements ConfigurationValidator {
    @Nonnull
    public Map<String, String> validate(@Nonnull Collection<SettingValidator> settingValidators, @Nonnull Map<String, String> rawConfig, @Nonnull Log log, boolean parsingFile) throws InvalidSettingException {
        ClusterSettings.Mode mode = (ClusterSettings.Mode)ClusterSettings.mode.apply(rawConfig::get);
        if (!mode.equals((Object)ClusterSettings.Mode.CORE) && !mode.equals((Object)ClusterSettings.Mode.READ_REPLICA)) {
            return rawConfig;
        }
        CausalClusterConfigurationValidator.validateInitialDiscoveryMembers(rawConfig::get);
        CausalClusterConfigurationValidator.validateBoltConnector(rawConfig);
        CausalClusterConfigurationValidator.validateLoadBalancing(rawConfig, log);
        return rawConfig;
    }

    private static void validateLoadBalancing(Map<String, String> rawConfig, Log log) {
        LoadBalancingPluginLoader.validate(Config.defaults().augment(rawConfig), log);
    }

    private static void validateBoltConnector(Map<String, String> rawConfig) {
        if (Config.enabledBoltConnectors(rawConfig).isEmpty()) {
            throw new InvalidSettingException("A Bolt connector must be configured to run a cluster");
        }
    }

    private static void validateInitialDiscoveryMembers(Function<String, String> provider) {
        if (CausalClusteringSettings.initial_discovery_members.apply(provider) == null) {
            throw new InvalidSettingException(String.format("Missing mandatory non-empty value for '%s'", CausalClusteringSettings.initial_discovery_members.name()));
        }
    }
}

