/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core;

import java.io.File;
import java.util.function.Function;
import org.neo4j.causalclustering.core.EnterpriseCoreEditionModule;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.discovery.DiscoveryServiceFactory;
import org.neo4j.causalclustering.discovery.HazelcastDiscoveryServiceFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.EditionModule;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.factory.PlatformModule;

public class CoreGraphDatabase
extends GraphDatabaseFacade {
    public CoreGraphDatabase(File storeDir, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
        this(storeDir, config, dependencies, new HazelcastDiscoveryServiceFactory());
    }

    public CoreGraphDatabase(File storeDir, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies, DiscoveryServiceFactory discoveryServiceFactory) {
        Function<PlatformModule, EditionModule> factory = platformModule -> new EnterpriseCoreEditionModule((PlatformModule)platformModule, discoveryServiceFactory);
        new GraphDatabaseFacadeFactory(DatabaseInfo.CORE, factory).initFacade(storeDir, config, dependencies, (GraphDatabaseFacade)this);
    }

    public Role getRole() {
        return ((RaftMachine)this.getDependencyResolver().resolveDependency(RaftMachine.class)).currentRole();
    }
}

