/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus;

import java.io.File;
import java.time.Duration;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.EnterpriseCoreEditionModule;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.log.InMemoryRaftLog;
import org.neo4j.causalclustering.core.consensus.log.MonitoredRaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.log.segmented.CoreLogPruningStrategy;
import org.neo4j.causalclustering.core.consensus.log.segmented.CoreLogPruningStrategyFactory;
import org.neo4j.causalclustering.core.consensus.log.segmented.InFlightMap;
import org.neo4j.causalclustering.core.consensus.log.segmented.SegmentedRaftLog;
import org.neo4j.causalclustering.core.consensus.membership.MemberIdSetBuilder;
import org.neo4j.causalclustering.core.consensus.membership.RaftMembershipManager;
import org.neo4j.causalclustering.core.consensus.membership.RaftMembershipState;
import org.neo4j.causalclustering.core.consensus.schedule.DelayedRenewableTimeoutService;
import org.neo4j.causalclustering.core.consensus.shipping.RaftLogShippingManager;
import org.neo4j.causalclustering.core.consensus.term.MonitoredTermStateStorage;
import org.neo4j.causalclustering.core.consensus.term.TermState;
import org.neo4j.causalclustering.core.consensus.vote.VoteState;
import org.neo4j.causalclustering.core.replication.SendToMyself;
import org.neo4j.causalclustering.core.state.RefuseToBeLeaderStrategy;
import org.neo4j.causalclustering.core.state.storage.DurableStateStorage;
import org.neo4j.causalclustering.core.state.storage.StateStorage;
import org.neo4j.causalclustering.discovery.CoreTopologyService;
import org.neo4j.causalclustering.discovery.RaftCoreTopologyConnector;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.CoreReplicatedContentMarshal;
import org.neo4j.causalclustering.messaging.Outbound;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.LogProvider;
import org.neo4j.time.Clocks;

public class ConsensusModule {
    public static final String RAFT_MEMBERSHIP_NAME = "membership";
    public static final String RAFT_TERM_NAME = "term";
    public static final String RAFT_VOTE_NAME = "vote";
    private final MonitoredRaftLog raftLog;
    private final RaftMachine raftMachine;
    private final DelayedRenewableTimeoutService raftTimeoutService;
    private final RaftMembershipManager raftMembershipManager;
    private final InFlightMap<RaftLogEntry> inFlightMap = new InFlightMap();

    public ConsensusModule(MemberId myself, PlatformModule platformModule, Outbound<MemberId, RaftMessages.RaftMessage> outbound, File clusterStateDirectory, CoreTopologyService coreTopologyService) {
        Config config = platformModule.config;
        LogService logging = platformModule.logging;
        FileSystemAbstraction fileSystem = platformModule.fileSystem;
        LifeSupport life = platformModule.life;
        LogProvider logProvider = logging.getInternalLogProvider();
        CoreReplicatedContentMarshal marshal = new CoreReplicatedContentMarshal();
        RaftLog underlyingLog = this.createRaftLog(config, life, fileSystem, clusterStateDirectory, marshal, logProvider, platformModule.jobScheduler);
        this.raftLog = new MonitoredRaftLog(underlyingLog, platformModule.monitors);
        StateStorage durableTermState = (StateStorage)life.add(new DurableStateStorage<TermState>(fileSystem, clusterStateDirectory, RAFT_TERM_NAME, new TermState.Marshal(), (Integer)config.get(CausalClusteringSettings.term_state_size), logProvider));
        MonitoredTermStateStorage termState = new MonitoredTermStateStorage(durableTermState, platformModule.monitors);
        StateStorage voteState = (StateStorage)life.add(new DurableStateStorage<VoteState>(fileSystem, clusterStateDirectory, RAFT_VOTE_NAME, new VoteState.Marshal(new MemberId.Marshal()), (Integer)config.get(CausalClusteringSettings.vote_state_size), logProvider));
        StateStorage raftMembershipStorage = (StateStorage)life.add(new DurableStateStorage<RaftMembershipState>(fileSystem, clusterStateDirectory, RAFT_MEMBERSHIP_NAME, new RaftMembershipState.Marshal(), (Integer)config.get(CausalClusteringSettings.raft_membership_state_size), logProvider));
        long electionTimeout = ((Duration)config.get(CausalClusteringSettings.leader_election_timeout)).toMillis();
        long heartbeatInterval = electionTimeout / 3L;
        Integer expectedClusterSize = (Integer)config.get(CausalClusteringSettings.expected_core_cluster_size);
        MemberIdSetBuilder memberSetBuilder = new MemberIdSetBuilder();
        SendToMyself leaderOnlyReplicator = new SendToMyself(myself, outbound);
        this.raftMembershipManager = new RaftMembershipManager(leaderOnlyReplicator, memberSetBuilder, this.raftLog, logProvider, expectedClusterSize, electionTimeout, Clocks.systemClock(), ((Duration)config.get(CausalClusteringSettings.join_catch_up_timeout)).toMillis(), raftMembershipStorage);
        life.add((Lifecycle)this.raftMembershipManager);
        RaftLogShippingManager logShipping = new RaftLogShippingManager(outbound, logProvider, this.raftLog, Clocks.systemClock(), myself, this.raftMembershipManager, electionTimeout, (Integer)config.get(CausalClusteringSettings.catchup_batch_size), (Integer)config.get(CausalClusteringSettings.log_shipping_max_lag), this.inFlightMap);
        this.raftTimeoutService = new DelayedRenewableTimeoutService(Clocks.systemClock(), logProvider);
        this.raftMachine = new RaftMachine(myself, termState, voteState, this.raftLog, electionTimeout, heartbeatInterval, this.raftTimeoutService, outbound, logProvider, this.raftMembershipManager, logShipping, this.inFlightMap, RefuseToBeLeaderStrategy.shouldRefuseToBeLeader(config, logProvider.getLog(this.getClass())), platformModule.monitors, Clocks.systemClock());
        life.add((Lifecycle)new RaftCoreTopologyConnector(coreTopologyService, this.raftMachine));
        life.add((Lifecycle)logShipping);
    }

    private RaftLog createRaftLog(Config config, LifeSupport life, FileSystemAbstraction fileSystem, File clusterStateDirectory, CoreReplicatedContentMarshal marshal, LogProvider logProvider, JobScheduler scheduler) {
        EnterpriseCoreEditionModule.RaftLogImplementation raftLogImplementation = EnterpriseCoreEditionModule.RaftLogImplementation.valueOf((String)config.get(CausalClusteringSettings.raft_log_implementation));
        switch (raftLogImplementation) {
            case IN_MEMORY: {
                return new InMemoryRaftLog();
            }
            case SEGMENTED: {
                long rotateAtSize = (Long)config.get(CausalClusteringSettings.raft_log_rotation_size);
                int readerPoolSize = (Integer)config.get(CausalClusteringSettings.raft_log_reader_pool_size);
                CoreLogPruningStrategy pruningStrategy = new CoreLogPruningStrategyFactory((String)config.get(CausalClusteringSettings.raft_log_pruning_strategy), logProvider).newInstance();
                File directory = new File(clusterStateDirectory, "raft-log");
                return (RaftLog)life.add((Lifecycle)new SegmentedRaftLog(fileSystem, directory, rotateAtSize, marshal, logProvider, readerPoolSize, Clocks.systemClock(), scheduler, pruningStrategy));
            }
        }
        throw new IllegalStateException("Unknown raft log implementation: " + (Object)((Object)raftLogImplementation));
    }

    public RaftLog raftLog() {
        return this.raftLog;
    }

    public RaftMachine raftMachine() {
        return this.raftMachine;
    }

    public Lifecycle raftTimeoutService() {
        return this.raftTimeoutService;
    }

    public RaftMembershipManager raftMembershipManager() {
        return this.raftMembershipManager;
    }

    public InFlightMap<RaftLogEntry> inFlightMap() {
        return this.inFlightMap;
    }
}

