/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.segmented;

import java.io.IOException;
import java.util.Optional;
import org.neo4j.causalclustering.core.consensus.log.EntryRecord;
import org.neo4j.causalclustering.core.consensus.log.segmented.DisposedException;
import org.neo4j.causalclustering.core.consensus.log.segmented.OpenEndRangeMap;
import org.neo4j.causalclustering.core.consensus.log.segmented.SegmentFile;
import org.neo4j.causalclustering.core.consensus.log.segmented.Segments;
import org.neo4j.cursor.CursorValue;
import org.neo4j.cursor.IOCursor;

class EntryCursor
implements IOCursor<EntryRecord> {
    private final Segments segments;
    private IOCursor<EntryRecord> cursor;
    private OpenEndRangeMap.ValueRange<Long, SegmentFile> segmentRange = null;
    private long currentIndex;
    private long limit = Long.MAX_VALUE;
    private CursorValue<EntryRecord> currentRecord = new CursorValue();

    EntryCursor(Segments segments, long logIndex) throws IOException {
        this.segments = segments;
        this.currentIndex = logIndex - 1L;
    }

    public boolean next() throws IOException {
        ++this.currentIndex;
        if (!(this.segmentRange != null && this.currentIndex < this.limit || this.nextSegment())) {
            return false;
        }
        if (this.cursor.next()) {
            this.currentRecord.set(this.cursor.get());
            return true;
        }
        this.currentRecord.invalidate();
        return false;
    }

    private boolean nextSegment() throws IOException {
        this.segmentRange = this.segments.getForIndex(this.currentIndex);
        Optional<SegmentFile> optionalFile = this.segmentRange.value();
        if (!optionalFile.isPresent()) {
            this.currentRecord.invalidate();
            return false;
        }
        SegmentFile file = optionalFile.get();
        IOCursor<EntryRecord> oldCursor = this.cursor;
        try {
            this.cursor = file.getCursor(this.currentIndex);
        }
        catch (DisposedException e) {
            this.currentRecord.invalidate();
            return false;
        }
        if (oldCursor != null) {
            oldCursor.close();
        }
        this.limit = this.segmentRange.limit().orElse(Long.MAX_VALUE);
        return true;
    }

    public void close() throws IOException {
        if (this.cursor != null) {
            this.cursor.close();
        }
    }

    public EntryRecord get() {
        return (EntryRecord)this.currentRecord.get();
    }
}

