/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.segmented;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;

class OpenEndRangeMap<K extends Comparable<K>, V> {
    private final TreeMap<K, V> tree = new TreeMap();
    private K endKey = null;
    private V endValue = null;

    OpenEndRangeMap() {
    }

    Collection<V> replaceFrom(K from, V value) {
        ArrayList<V> removed = new ArrayList<V>();
        Iterator<V> itr = this.tree.tailMap(from).values().iterator();
        while (itr.hasNext()) {
            removed.add(itr.next());
            itr.remove();
        }
        this.tree.put(from, value);
        this.endKey = from;
        this.endValue = value;
        return removed;
    }

    ValueRange<K, V> lookup(K at) {
        if (this.endKey != null && this.endKey.compareTo(at) <= 0) {
            return new ValueRange<Object, V>(null, this.endValue);
        }
        Map.Entry<K, V> entry = this.tree.floorEntry(at);
        return new ValueRange<K, Object>(this.tree.higherKey(at), (entry != null ? (Object)entry.getValue() : null));
    }

    public V last() {
        return this.endValue;
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.tree.entrySet();
    }

    public Collection<V> remove(K lessThan) {
        ArrayList removed = new ArrayList();
        Comparable floor = (Comparable)this.tree.floorKey(lessThan);
        Iterator itr = this.tree.headMap(floor, false).values().iterator();
        while (itr.hasNext()) {
            removed.add(itr.next());
            itr.remove();
        }
        if (this.tree.isEmpty()) {
            this.endKey = null;
            this.endValue = null;
        }
        return removed;
    }

    static class ValueRange<K, V> {
        private final K limit;
        private final V value;

        ValueRange(K limit, V value) {
            this.limit = limit;
            this.value = value;
        }

        Optional<K> limit() {
            return Optional.ofNullable(this.limit);
        }

        Optional<V> value() {
            return Optional.ofNullable(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ValueRange that = (ValueRange)o;
            return Objects.equals(this.limit, that.limit) && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.limit, this.value);
        }
    }
}

