/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.membership;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.causalclustering.core.consensus.membership.MemberIdSet;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.EndOfStreamException;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class MemberIdSetSerializer {
    public static void marshal(MemberIdSet memberSet, WritableChannel channel) throws IOException {
        Set<MemberId> members = memberSet.getMembers();
        channel.putInt(members.size());
        MemberId.Marshal memberIdMarshal = new MemberId.Marshal();
        for (MemberId member : members) {
            memberIdMarshal.marshal(member, channel);
        }
    }

    public static MemberIdSet unmarshal(ReadableChannel channel) throws IOException, EndOfStreamException {
        HashSet<MemberId> members = new HashSet<MemberId>();
        int memberCount = channel.getInt();
        MemberId.Marshal memberIdMarshal = new MemberId.Marshal();
        for (int i = 0; i < memberCount; ++i) {
            members.add((MemberId)memberIdMarshal.unmarshal(channel));
        }
        return new MemberIdSet(members);
    }
}

