/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.membership;

import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.neo4j.causalclustering.core.consensus.membership.MembershipEntry;
import org.neo4j.causalclustering.core.state.storage.SafeStateMarshal;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.EndOfStreamException;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class RaftMembershipState
extends LifecycleAdapter {
    private MembershipEntry committed;
    private MembershipEntry appended;
    private long ordinal;

    public RaftMembershipState() {
        this(-1L, null, null);
    }

    RaftMembershipState(long ordinal, MembershipEntry committed, MembershipEntry appended) {
        this.ordinal = ordinal;
        this.committed = committed;
        this.appended = appended;
    }

    public boolean append(long logIndex, Set<MemberId> members) {
        if (this.appended != null && logIndex <= this.appended.logIndex()) {
            return false;
        }
        if (this.committed != null && logIndex <= this.committed.logIndex()) {
            return false;
        }
        if (this.appended != null && (this.committed == null || this.appended.logIndex() > this.committed.logIndex())) {
            this.committed = this.appended;
        }
        ++this.ordinal;
        this.appended = new MembershipEntry(logIndex, members);
        return true;
    }

    public boolean truncate(long fromIndex) {
        if (this.committed != null && fromIndex <= this.committed.logIndex()) {
            throw new IllegalStateException("Truncating committed entry");
        }
        if (this.appended != null && fromIndex <= this.appended.logIndex()) {
            ++this.ordinal;
            this.appended = null;
            return true;
        }
        return false;
    }

    public boolean commit(long commitIndex) {
        if (this.appended != null && commitIndex >= this.appended.logIndex()) {
            ++this.ordinal;
            this.committed = this.appended;
            this.appended = null;
            return true;
        }
        return false;
    }

    boolean uncommittedMemberChangeInLog() {
        return this.appended != null;
    }

    Set<MemberId> getLatest() {
        return this.appended != null ? this.appended.members() : (this.committed != null ? this.committed.members() : new HashSet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        RaftMembershipState that = (RaftMembershipState)((Object)o);
        return this.ordinal == that.ordinal && Objects.equals(this.committed, that.committed) && Objects.equals(this.appended, that.appended);
    }

    public int hashCode() {
        return Objects.hash(this.committed, this.appended, this.ordinal);
    }

    public String toString() {
        return "RaftMembershipState{committed=" + this.committed + ", appended=" + this.appended + ", ordinal=" + this.ordinal + '}';
    }

    public RaftMembershipState newInstance() {
        return new RaftMembershipState(this.ordinal, this.committed, this.appended);
    }

    public MembershipEntry committed() {
        return this.committed;
    }

    public long getOrdinal() {
        return this.ordinal;
    }

    public static class Marshal
    extends SafeStateMarshal<RaftMembershipState> {
        MembershipEntry.Marshal entryMarshal = new MembershipEntry.Marshal();

        @Override
        public RaftMembershipState startState() {
            return new RaftMembershipState();
        }

        @Override
        public long ordinal(RaftMembershipState state) {
            return state.ordinal;
        }

        @Override
        public void marshal(RaftMembershipState state, WritableChannel channel) throws IOException {
            channel.putLong(state.ordinal);
            this.entryMarshal.marshal(state.committed, channel);
            this.entryMarshal.marshal(state.appended, channel);
        }

        @Override
        public RaftMembershipState unmarshal0(ReadableChannel channel) throws IOException, EndOfStreamException {
            long ordinal = channel.getLong();
            MembershipEntry committed = (MembershipEntry)this.entryMarshal.unmarshal(channel);
            MembershipEntry appended = (MembershipEntry)this.entryMarshal.unmarshal(channel);
            return new RaftMembershipState(ordinal, committed, appended);
        }
    }
}

