/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.outcome;

import java.io.IOException;
import java.util.Objects;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.log.segmented.InFlightMap;
import org.neo4j.causalclustering.core.consensus.outcome.RaftLogCommand;
import org.neo4j.logging.Log;

public class TruncateLogCommand
implements RaftLogCommand {
    public final long fromIndex;

    public TruncateLogCommand(long fromIndex) {
        this.fromIndex = fromIndex;
    }

    @Override
    public void dispatch(RaftLogCommand.Handler handler) throws IOException {
        handler.truncate(this.fromIndex);
    }

    @Override
    public void applyTo(RaftLog raftLog, Log log) throws IOException {
        raftLog.truncate(this.fromIndex);
    }

    @Override
    public void applyTo(InFlightMap<RaftLogEntry> inFlightMap, Log log) throws IOException {
        log.debug("Start truncating in-flight-map from index %d. Current map:%n%s", new Object[]{this.fromIndex, inFlightMap});
        inFlightMap.truncate(this.fromIndex);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TruncateLogCommand that = (TruncateLogCommand)o;
        return this.fromIndex == that.fromIndex;
    }

    public int hashCode() {
        return Objects.hash(this.fromIndex);
    }

    public String toString() {
        return "TruncateLogCommand{fromIndex=" + this.fromIndex + '}';
    }
}

