/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.state;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.log.ReadableRaftLog;
import org.neo4j.causalclustering.core.consensus.log.segmented.InFlightMap;
import org.neo4j.causalclustering.core.consensus.membership.RaftMembership;
import org.neo4j.causalclustering.core.consensus.outcome.Outcome;
import org.neo4j.causalclustering.core.consensus.outcome.RaftLogCommand;
import org.neo4j.causalclustering.core.consensus.roles.follower.FollowerStates;
import org.neo4j.causalclustering.core.consensus.state.ExposedRaftState;
import org.neo4j.causalclustering.core.consensus.state.ReadableRaftState;
import org.neo4j.causalclustering.core.consensus.term.TermState;
import org.neo4j.causalclustering.core.consensus.vote.VoteState;
import org.neo4j.causalclustering.core.state.storage.StateStorage;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class RaftState
implements ReadableRaftState {
    private final MemberId myself;
    private final StateStorage<TermState> termStorage;
    private final StateStorage<VoteState> voteStorage;
    private final RaftMembership membership;
    private final Log log;
    private final RaftLog entryLog;
    private final InFlightMap<RaftLogEntry> inFlightMap;
    private TermState termState;
    private VoteState voteState;
    private MemberId leader;
    private Set<MemberId> votesForMe = new HashSet<MemberId>();
    private Set<MemberId> heartbeatResponses = new HashSet<MemberId>();
    private FollowerStates<MemberId> followerStates = new FollowerStates();
    private long leaderCommit = -1L;
    private long commitIndex = -1L;
    private long lastLogIndexBeforeWeBecameLeader = -1L;

    public RaftState(MemberId myself, StateStorage<TermState> termStorage, RaftMembership membership, RaftLog entryLog, StateStorage<VoteState> voteStorage, InFlightMap<RaftLogEntry> inFlightMap, LogProvider logProvider) {
        this.myself = myself;
        this.termStorage = termStorage;
        this.voteStorage = voteStorage;
        this.membership = membership;
        this.entryLog = entryLog;
        this.inFlightMap = inFlightMap;
        this.log = logProvider.getLog(this.getClass());
    }

    @Override
    public MemberId myself() {
        return this.myself;
    }

    @Override
    public Set<MemberId> votingMembers() {
        return this.membership.votingMembers();
    }

    @Override
    public Set<MemberId> replicationMembers() {
        return this.membership.replicationMembers();
    }

    @Override
    public long term() {
        return this.termState().currentTerm();
    }

    private TermState termState() {
        if (this.termState == null) {
            this.termState = this.termStorage.getInitialState();
        }
        return this.termState;
    }

    @Override
    public MemberId leader() {
        return this.leader;
    }

    @Override
    public long leaderCommit() {
        return this.leaderCommit;
    }

    @Override
    public MemberId votedFor() {
        return this.voteState().votedFor();
    }

    private VoteState voteState() {
        if (this.voteState == null) {
            this.voteState = this.voteStorage.getInitialState();
        }
        return this.voteState;
    }

    @Override
    public Set<MemberId> votesForMe() {
        return this.votesForMe;
    }

    @Override
    public Set<MemberId> heartbeatResponses() {
        return this.heartbeatResponses;
    }

    @Override
    public long lastLogIndexBeforeWeBecameLeader() {
        return this.lastLogIndexBeforeWeBecameLeader;
    }

    @Override
    public FollowerStates<MemberId> followerStates() {
        return this.followerStates;
    }

    @Override
    public ReadableRaftLog entryLog() {
        return this.entryLog;
    }

    @Override
    public long commitIndex() {
        return this.commitIndex;
    }

    public void update(Outcome outcome) throws IOException {
        if (this.termState().update(outcome.getTerm())) {
            this.termStorage.persistStoreData(this.termState());
        }
        if (this.voteState().update(outcome.getVotedFor(), outcome.getTerm())) {
            this.voteStorage.persistStoreData(this.voteState());
        }
        this.logIfLeaderChanged(outcome.getLeader());
        this.leader = outcome.getLeader();
        this.leaderCommit = outcome.getLeaderCommit();
        this.votesForMe = outcome.getVotesForMe();
        this.heartbeatResponses = outcome.getHeartbeatResponses();
        this.lastLogIndexBeforeWeBecameLeader = outcome.getLastLogIndexBeforeWeBecameLeader();
        this.followerStates = outcome.getFollowerStates();
        for (RaftLogCommand logCommand : outcome.getLogCommands()) {
            logCommand.applyTo(this.entryLog, this.log);
            logCommand.applyTo(this.inFlightMap, this.log);
        }
        this.commitIndex = outcome.getCommitIndex();
    }

    private void logIfLeaderChanged(MemberId leader) {
        if (this.leader == null) {
            if (leader != null) {
                this.log.info("First leader elected: %s", new Object[]{leader});
            }
            return;
        }
        if (!this.leader.equals(leader)) {
            this.log.info("Leader changed from %s to %s", new Object[]{this.leader, leader});
        }
    }

    public ExposedRaftState copy() {
        return new ReadOnlyRaftState(this.leaderCommit(), this.commitIndex(), this.entryLog().appendIndex(), this.lastLogIndexBeforeWeBecameLeader(), this.term(), this.votingMembers());
    }

    private class ReadOnlyRaftState
    implements ExposedRaftState {
        final long leaderCommit;
        final long commitIndex;
        final long appendIndex;
        final long lastLogIndexBeforeWeBecameLeader;
        final long term;
        final Set<MemberId> votingMembers;

        private ReadOnlyRaftState(long leaderCommit, long commitIndex, long appendIndex, long lastLogIndexBeforeWeBecameLeader, long term, Set<MemberId> votingMembers) {
            this.leaderCommit = leaderCommit;
            this.commitIndex = commitIndex;
            this.appendIndex = appendIndex;
            this.lastLogIndexBeforeWeBecameLeader = lastLogIndexBeforeWeBecameLeader;
            this.term = term;
            this.votingMembers = votingMembers;
        }

        @Override
        public long lastLogIndexBeforeWeBecameLeader() {
            return this.lastLogIndexBeforeWeBecameLeader;
        }

        @Override
        public long leaderCommit() {
            return this.leaderCommit;
        }

        @Override
        public long commitIndex() {
            return this.commitIndex;
        }

        @Override
        public long appendIndex() {
            return this.appendIndex;
        }

        @Override
        public long term() {
            return this.term;
        }

        @Override
        public Set<MemberId> votingMembers() {
            return this.votingMembers;
        }
    }
}

