/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.replication.session;

import java.util.EmptyStackException;
import java.util.Stack;
import org.neo4j.causalclustering.core.replication.session.GlobalSession;
import org.neo4j.causalclustering.core.replication.session.LocalSession;
import org.neo4j.causalclustering.core.replication.session.OperationContext;

public class LocalSessionPool {
    private final Stack<LocalSession> sessionStack = new Stack();
    private final GlobalSession globalSession;
    private long nextLocalSessionId;

    public LocalSessionPool(GlobalSession globalSession) {
        this.globalSession = globalSession;
    }

    private LocalSession createSession() {
        return new LocalSession(this.nextLocalSessionId++);
    }

    public GlobalSession getGlobalSession() {
        return this.globalSession;
    }

    public synchronized OperationContext acquireSession() {
        LocalSession localSession;
        try {
            localSession = this.sessionStack.pop();
        }
        catch (EmptyStackException e) {
            localSession = this.createSession();
        }
        return new OperationContext(this.globalSession, localSession.nextOperationId(), localSession);
    }

    public synchronized void releaseSession(OperationContext operationContext) {
        this.sessionStack.push(operationContext.localSession());
    }

    public synchronized long openSessionCount() {
        return this.nextLocalSessionId - (long)this.sessionStack.size();
    }
}

