/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.server;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.messaging.Inbound;
import org.neo4j.function.Predicates;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

class BatchingMessageHandler
extends LifecycleAdapter
implements Runnable,
Inbound.MessageHandler<RaftMessages.ClusterIdAwareMessage> {
    private final Inbound.MessageHandler<RaftMessages.ClusterIdAwareMessage> handler;
    private final Log log;
    private final int maxBatch;
    private final List<RaftMessages.ClusterIdAwareMessage> batch;
    private final BlockingQueue<RaftMessages.ClusterIdAwareMessage> messageQueue;
    private volatile boolean stopped;

    BatchingMessageHandler(Inbound.MessageHandler<RaftMessages.ClusterIdAwareMessage> handler, int queueSize, int maxBatch, LogProvider logProvider) {
        this.handler = handler;
        this.log = logProvider.getLog(this.getClass());
        this.maxBatch = maxBatch;
        this.batch = new ArrayList<RaftMessages.ClusterIdAwareMessage>(maxBatch);
        this.messageQueue = new ArrayBlockingQueue<RaftMessages.ClusterIdAwareMessage>(queueSize);
    }

    public void stop() {
        this.stopped = true;
    }

    @Override
    public void handle(RaftMessages.ClusterIdAwareMessage message) {
        if (this.stopped) {
            this.log.debug("This handler has been stopped, dropping the message: %s", new Object[]{message});
            return;
        }
        Predicates.awaitForever(() -> this.stopped || this.messageQueue.offer(message), (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    @Override
    public void run() {
        RaftMessages.ClusterIdAwareMessage message = null;
        try {
            message = this.messageQueue.poll(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.log.warn("Not expecting to be interrupted.", (Throwable)e);
        }
        if (message != null) {
            if (this.messageQueue.isEmpty()) {
                this.handler.handle(message);
            } else {
                this.batch.clear();
                this.batch.add(message);
                this.drain(this.messageQueue, this.batch, this.maxBatch - 1);
                this.collateAndHandleBatch(this.batch);
            }
        }
    }

    private void drain(BlockingQueue<RaftMessages.ClusterIdAwareMessage> messageQueue, List<RaftMessages.ClusterIdAwareMessage> batch, int maxElements) {
        ArrayList tempDraining = new ArrayList();
        messageQueue.drainTo(tempDraining, maxElements);
        for (RaftMessages.ClusterIdAwareMessage clusterIdAwareMessage : tempDraining) {
            batch.add(clusterIdAwareMessage);
        }
    }

    private void collateAndHandleBatch(List<RaftMessages.ClusterIdAwareMessage> batch) {
        RaftMessages.NewEntry.BatchRequest batchRequest = null;
        ClusterId clusterId = batch.get(0).clusterId();
        for (RaftMessages.ClusterIdAwareMessage clusterIdAwareMessage : batch) {
            if (batchRequest != null && !clusterIdAwareMessage.clusterId().equals(clusterId)) {
                this.handler.handle(new RaftMessages.ClusterIdAwareMessage(clusterId, batchRequest));
                batchRequest = null;
            }
            clusterId = clusterIdAwareMessage.clusterId();
            RaftMessages.RaftMessage message = clusterIdAwareMessage.message();
            if (message instanceof RaftMessages.NewEntry.Request) {
                RaftMessages.NewEntry.Request newEntryRequest = (RaftMessages.NewEntry.Request)message;
                if (batchRequest == null) {
                    batchRequest = new RaftMessages.NewEntry.BatchRequest(batch.size());
                }
                batchRequest.add(newEntryRequest.content());
                continue;
            }
            this.handler.handle(clusterIdAwareMessage);
        }
        if (batchRequest != null) {
            this.handler.handle(new RaftMessages.ClusterIdAwareMessage(clusterId, batchRequest));
        }
    }
}

