/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state;

import java.io.File;
import java.io.IOException;
import org.neo4j.causalclustering.core.state.ClusterStateException;
import org.neo4j.io.fs.FileSystemAbstraction;

public class ClusterStateDirectory {
    static final String CLUSTER_STATE_DIRECTORY_NAME = "cluster-state";
    private final File stateDir;
    private final File storeDir;
    private final boolean readOnly;
    private boolean initialized;

    public ClusterStateDirectory(File dataDir) {
        this(dataDir, null, true);
    }

    public ClusterStateDirectory(File dataDir, boolean readOnly) {
        this(dataDir, dataDir, readOnly);
    }

    public ClusterStateDirectory(File dataDir, File storeDir, boolean readOnly) {
        this.storeDir = storeDir;
        this.readOnly = readOnly;
        this.stateDir = new File(dataDir, CLUSTER_STATE_DIRECTORY_NAME);
    }

    public ClusterStateDirectory initialize(FileSystemAbstraction fs) throws ClusterStateException {
        assert (!this.initialized);
        if (!this.readOnly) {
            this.migrateIfNeeded(fs);
        }
        this.ensureDirectoryExists(fs);
        this.initialized = true;
        return this;
    }

    public static ClusterStateDirectory withoutInitializing(File dataDir) {
        ClusterStateDirectory clusterStateDirectory = new ClusterStateDirectory(dataDir);
        clusterStateDirectory.initialized = true;
        return clusterStateDirectory;
    }

    private void migrateIfNeeded(FileSystemAbstraction fs) throws ClusterStateException {
        File oldStateDir = new File(this.storeDir, CLUSTER_STATE_DIRECTORY_NAME);
        if (!fs.fileExists(oldStateDir) || oldStateDir.equals(this.stateDir)) {
            return;
        }
        if (fs.fileExists(this.stateDir)) {
            throw new ClusterStateException("Cluster state exists in both old and new locations");
        }
        try {
            fs.moveToDirectory(oldStateDir, this.stateDir.getParentFile());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to migrate cluster state directory", e);
        }
    }

    private void ensureDirectoryExists(FileSystemAbstraction fs) throws ClusterStateException {
        if (!fs.fileExists(this.stateDir)) {
            if (this.readOnly) {
                throw new ClusterStateException("Cluster state directory does not exist");
            }
            try {
                fs.mkdirs(this.stateDir);
            }
            catch (IOException e) {
                throw new ClusterStateException(e);
            }
        }
    }

    public File get() {
        if (!this.initialized) {
            throw new IllegalStateException("Cluster state has not been initialized");
        }
        return this.stateDir;
    }
}

