/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state;

import java.util.concurrent.TimeoutException;
import org.neo4j.causalclustering.catchup.storecopy.LocalDatabase;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFailedException;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.outcome.ConsensusOutcome;
import org.neo4j.causalclustering.core.state.CommandApplicationProcess;
import org.neo4j.causalclustering.core.state.snapshot.CoreStateDownloader;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.Inbound;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class RaftMessageHandler
implements Inbound.MessageHandler<RaftMessages.ClusterIdAwareMessage> {
    private final LocalDatabase localDatabase;
    private final Log log;
    private final RaftMachine raftMachine;
    private final CoreStateDownloader downloader;
    private final CommandApplicationProcess applicationProcess;
    private ClusterId boundClusterId;

    public RaftMessageHandler(LocalDatabase localDatabase, LogProvider logProvider, RaftMachine raftMachine, CoreStateDownloader downloader, CommandApplicationProcess applicationProcess) {
        this.localDatabase = localDatabase;
        this.log = logProvider.getLog(this.getClass());
        this.raftMachine = raftMachine;
        this.downloader = downloader;
        this.applicationProcess = applicationProcess;
    }

    @Override
    public synchronized void handle(RaftMessages.ClusterIdAwareMessage clusterIdAwareMessage) {
        block6: {
            if (this.boundClusterId == null) {
                return;
            }
            ClusterId msgClusterId = clusterIdAwareMessage.clusterId();
            if (msgClusterId.equals(this.boundClusterId)) {
                try {
                    ConsensusOutcome outcome = this.raftMachine.handle(clusterIdAwareMessage.message());
                    if (outcome.needsFreshSnapshot()) {
                        this.downloadSnapshot(clusterIdAwareMessage.message().from());
                        break block6;
                    }
                    this.notifyCommitted(outcome.getCommitIndex());
                }
                catch (Throwable e) {
                    this.log.error("Error handling message", e);
                    this.raftMachine.panic();
                    this.localDatabase.panic(e);
                }
            } else {
                this.log.info("Discarding message[%s] owing to mismatched clusterId. Expected: %s, Encountered: %s", new Object[]{clusterIdAwareMessage.message(), this.boundClusterId, msgClusterId});
            }
        }
    }

    synchronized void start(ClusterId clusterId) throws TimeoutException {
        this.boundClusterId = clusterId;
    }

    synchronized void stop() {
        this.boundClusterId = null;
    }

    private void notifyCommitted(long commitIndex) {
        this.applicationProcess.notifyCommitted(commitIndex);
    }

    private void downloadSnapshot(MemberId source) throws Throwable {
        try {
            this.downloader.downloadSnapshot(source);
        }
        catch (StoreCopyFailedException e) {
            this.log.error("Failed to download snapshot", (Throwable)e);
        }
    }
}

