/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state;

import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;

public class RefuseToBeLeaderStrategy {
    public static boolean shouldRefuseToBeLeader(Config config) {
        boolean multiDcLicensed = (Boolean)config.get(CausalClusteringSettings.multi_dc_license);
        boolean refuseToBeLeader = (Boolean)config.get(CausalClusteringSettings.refuse_to_be_leader);
        return refuseToBeLeader && multiDcLicensed;
    }

    public static boolean shouldRefuseToBeLeader(Config config, Log log) {
        boolean multiDcLicensed = (Boolean)config.get(CausalClusteringSettings.multi_dc_license);
        boolean refuseToBeLeader = (Boolean)config.get(CausalClusteringSettings.refuse_to_be_leader);
        if (refuseToBeLeader && !multiDcLicensed) {
            log.warn(String.format("%s setting cannot be set to true unless %s is also set to true. Please refer to the Neo4j documentation for more information.", CausalClusteringSettings.refuse_to_be_leader.name(), CausalClusteringSettings.multi_dc_license.name()));
        }
        return RefuseToBeLeaderStrategy.shouldRefuseToBeLeader(config);
    }
}

