/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.id;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BooleanSupplier;
import org.neo4j.causalclustering.core.state.machines.id.FreeIdFilteredIdGenerator;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;

public class FreeIdFilteredIdGeneratorFactory
implements IdGeneratorFactory {
    private Map<IdType, IdGenerator> delegatedGenerator = new HashMap<IdType, IdGenerator>();
    private final IdGeneratorFactory delegate;
    private final BooleanSupplier freeIdCondition;

    public FreeIdFilteredIdGeneratorFactory(IdGeneratorFactory delegate, BooleanSupplier freeIdCondition) {
        this.delegate = delegate;
        this.freeIdCondition = freeIdCondition;
    }

    public IdGenerator open(File filename, IdType idType, long highId, long maxId) {
        FreeIdFilteredIdGenerator freeIdFilteredIdGenerator = new FreeIdFilteredIdGenerator(this.delegate.open(filename, idType, highId, maxId), this.freeIdCondition);
        this.delegatedGenerator.put(idType, (IdGenerator)freeIdFilteredIdGenerator);
        return freeIdFilteredIdGenerator;
    }

    public IdGenerator open(File filename, int grabSize, IdType idType, long highId, long maxId) {
        FreeIdFilteredIdGenerator freeIdFilteredIdGenerator = new FreeIdFilteredIdGenerator(this.delegate.open(filename, grabSize, idType, highId, maxId), this.freeIdCondition);
        this.delegatedGenerator.put(idType, (IdGenerator)freeIdFilteredIdGenerator);
        return freeIdFilteredIdGenerator;
    }

    public void create(File filename, long highId, boolean throwIfFileExists) {
        this.delegate.create(filename, highId, throwIfFileExists);
    }

    public IdGenerator get(IdType idType) {
        return this.delegatedGenerator.get(idType);
    }
}

