/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.id;

import java.util.function.BooleanSupplier;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.core.state.machines.id.CommandIndexTracker;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.kernel.impl.util.Listener;

public class IdReusabilityCondition
implements BooleanSupplier,
Listener<MemberId> {
    private static final BooleanSupplier ALWAYS_FALSE = () -> false;
    private CommandIndexTracker commandIndexTracker;
    private final RaftMachine raftMachine;
    private final MemberId myself;
    private volatile BooleanSupplier currentSupplier = ALWAYS_FALSE;

    public IdReusabilityCondition(CommandIndexTracker commandIndexTracker, RaftMachine raftMachine, MemberId myself) {
        this.commandIndexTracker = commandIndexTracker;
        this.raftMachine = raftMachine;
        this.myself = myself;
        raftMachine.registerListener(this);
    }

    @Override
    public boolean getAsBoolean() {
        return this.currentSupplier.getAsBoolean();
    }

    public void receive(MemberId newLeader) {
        this.currentSupplier = this.myself.equals(newLeader) ? new LeaderIdReusabilityCondition(this.commandIndexTracker, this.raftMachine) : ALWAYS_FALSE;
    }

    private static class LeaderIdReusabilityCondition
    implements BooleanSupplier {
        private final CommandIndexTracker commandIndexTracker;
        private final long commandIdWhenBecameLeader;
        private volatile boolean hasAppliedOldTransactions;

        LeaderIdReusabilityCondition(CommandIndexTracker commandIndexTracker, RaftMachine raftMachine) {
            this.commandIndexTracker = commandIndexTracker;
            this.commandIdWhenBecameLeader = raftMachine.state().lastLogIndexBeforeWeBecameLeader();
        }

        @Override
        public boolean getAsBoolean() {
            if (!this.hasAppliedOldTransactions) {
                this.hasAppliedOldTransactions = this.commandIndexTracker.getAppliedCommandIndex() > this.commandIdWhenBecameLeader;
            }
            return this.hasAppliedOldTransactions;
        }
    }
}

