/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.Optional;
import org.neo4j.causalclustering.discovery.CatchupServerAddress;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.ReadReplicaTopology;
import org.neo4j.causalclustering.identity.MemberId;

public class ClusterTopology {
    private final CoreTopology coreTopology;
    private final ReadReplicaTopology readReplicaTopology;

    public ClusterTopology(CoreTopology coreTopology, ReadReplicaTopology readReplicaTopology) {
        this.coreTopology = coreTopology;
        this.readReplicaTopology = readReplicaTopology;
    }

    public Optional<CatchupServerAddress> find(MemberId upstream) {
        Optional<CatchupServerAddress> coreCatchupAddress = this.coreTopology.find(upstream).map(a -> a);
        Optional<CatchupServerAddress> readCatchupAddress = this.readReplicaTopology.find(upstream).map(a -> a);
        return coreCatchupAddress.map(Optional::of).orElse(readCatchupAddress);
    }
}

