/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.causalclustering.discovery.CoreServerInfo;
import org.neo4j.causalclustering.discovery.Difference;
import org.neo4j.causalclustering.discovery.TopologyDifference;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;

public class CoreTopology {
    static CoreTopology EMPTY = new CoreTopology(null, false, Collections.emptyMap());
    private final ClusterId clusterId;
    private final boolean canBeBootstrapped;
    private final Map<MemberId, CoreServerInfo> coreMembers;

    public CoreTopology(ClusterId clusterId, boolean canBeBootstrapped, Map<MemberId, CoreServerInfo> coreMembers) {
        this.clusterId = clusterId;
        this.canBeBootstrapped = canBeBootstrapped;
        this.coreMembers = new HashMap<MemberId, CoreServerInfo>(coreMembers);
    }

    public Map<MemberId, CoreServerInfo> members() {
        return this.coreMembers;
    }

    public ClusterId clusterId() {
        return this.clusterId;
    }

    public boolean canBeBootstrapped() {
        return this.canBeBootstrapped;
    }

    public Optional<CoreServerInfo> find(MemberId memberId) {
        return Optional.ofNullable(this.coreMembers.get(memberId));
    }

    public String toString() {
        return String.format("{clusterId=%s, bootstrappable=%s, coreMembers=%s}", this.clusterId, this.canBeBootstrapped(), this.coreMembers);
    }

    TopologyDifference difference(CoreTopology other) {
        Set<MemberId> members = this.coreMembers.keySet();
        Set<MemberId> otherMembers = other.coreMembers.keySet();
        Set<Difference> added = otherMembers.stream().filter(m -> !members.contains(m)).map(memberId -> Difference.asDifference(other, memberId)).collect(Collectors.toSet());
        Set<Difference> removed = members.stream().filter(m -> !otherMembers.contains(m)).map(memberId -> Difference.asDifference(this, memberId)).collect(Collectors.toSet());
        return new TopologyDifference(added, removed);
    }

    public Optional<MemberId> anyCoreMemberId() {
        return this.coreMembers.keySet().stream().findAny();
    }
}

