/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.core.HazelcastInstance;
import java.util.List;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.HazelcastConnector;
import org.neo4j.causalclustering.discovery.HazelcastSslConfiguration;
import org.neo4j.causalclustering.discovery.HostnameResolver;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;
import org.neo4j.ssl.SslPolicy;

public class HazelcastClientConnector
implements HazelcastConnector {
    private final Config config;
    private final LogProvider logProvider;
    private final SslPolicy sslPolicy;
    private final HostnameResolver hostnameResolver;

    HazelcastClientConnector(Config config, LogProvider logProvider, SslPolicy sslPolicy, HostnameResolver hostnameResolver) {
        this.config = config;
        this.logProvider = logProvider;
        this.sslPolicy = sslPolicy;
        this.hostnameResolver = hostnameResolver;
    }

    @Override
    public HazelcastInstance connectToHazelcast() {
        ClientConfig clientConfig = new ClientConfig();
        ClientNetworkConfig networkConfig = clientConfig.getNetworkConfig();
        for (AdvertisedSocketAddress address : (List)this.config.get(CausalClusteringSettings.initial_discovery_members)) {
            for (AdvertisedSocketAddress advertisedSocketAddress : this.hostnameResolver.resolve(address)) {
                networkConfig.addAddress(new String[]{advertisedSocketAddress.toString()});
            }
        }
        HazelcastSslConfiguration.configureSsl(networkConfig, this.sslPolicy, this.logProvider);
        return HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
    }
}

