/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import com.hazelcast.config.MemberAttributeConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicReference;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Member;
import com.hazelcast.core.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.state.RefuseToBeLeaderStrategy;
import org.neo4j.causalclustering.discovery.ClientConnector;
import org.neo4j.causalclustering.discovery.ClientConnectorAddresses;
import org.neo4j.causalclustering.discovery.CoreServerInfo;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.ReadReplicaInfo;
import org.neo4j.causalclustering.discovery.ReadReplicaTopology;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.SocketAddressParser;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;

public class HazelcastClusterTopology {
    private static final String DISCOVERY_SERVER = "discovery_server";
    static final String MEMBER_UUID = "member_uuid";
    static final String TRANSACTION_SERVER = "transaction_server";
    static final String RAFT_SERVER = "raft_server";
    static final String CLIENT_CONNECTOR_ADDRESSES = "client_connector_addresses";
    private static final String REFUSE_TO_BE_LEADER_KEY = "refuseToBeLeader";
    private static final String CLUSTER_UUID = "cluster_uuid";
    static final String SERVER_GROUPS_MULTIMAP_NAME = "groups";
    static final String READ_REPLICA_TRANSACTION_SERVER_ADDRESS_MAP_NAME = "read-replica-transaction-servers";
    static final String READ_REPLICA_BOLT_ADDRESS_MAP_NAME = "read_replicas";
    static final String READ_REPLICA_MEMBER_ID_MAP_NAME = "read-replica-member-ids";

    static ReadReplicaTopology getReadReplicaTopology(HazelcastInstance hazelcastInstance, Log log) {
        Map<MemberId, ReadReplicaInfo> readReplicas = Collections.emptyMap();
        if (hazelcastInstance != null) {
            readReplicas = HazelcastClusterTopology.readReplicas(hazelcastInstance);
        } else {
            log.info("Cannot currently bind to distributed discovery service.");
        }
        return new ReadReplicaTopology(readReplicas);
    }

    static CoreTopology getCoreTopology(HazelcastInstance hazelcastInstance, Config config, Log log) {
        Map<MemberId, CoreServerInfo> coreMembers = Collections.emptyMap();
        boolean canBeBootstrapped = false;
        ClusterId clusterId = null;
        if (hazelcastInstance != null) {
            Set hzMembers = hazelcastInstance.getCluster().getMembers();
            canBeBootstrapped = HazelcastClusterTopology.canBeBootstrapped(hazelcastInstance, config);
            coreMembers = HazelcastClusterTopology.toCoreMemberMap(hzMembers, log, hazelcastInstance);
            clusterId = HazelcastClusterTopology.getClusterId(hazelcastInstance);
        } else {
            log.info("Cannot currently bind to distributed discovery service.");
        }
        return new CoreTopology(clusterId, canBeBootstrapped, coreMembers);
    }

    public static Map<MemberId, AdvertisedSocketAddress> extractCatchupAddressesMap(CoreTopology coreTopology, ReadReplicaTopology rrTopology) {
        HashMap<MemberId, AdvertisedSocketAddress> catchupAddressMap = new HashMap<MemberId, AdvertisedSocketAddress>();
        for (Map.Entry<MemberId, CoreServerInfo> entry : coreTopology.members().entrySet()) {
            catchupAddressMap.put(entry.getKey(), entry.getValue().getCatchupServer());
        }
        for (Map.Entry<MemberId, ClientConnector> entry : rrTopology.members().entrySet()) {
            catchupAddressMap.put(entry.getKey(), ((ReadReplicaInfo)entry.getValue()).getCatchupServer());
        }
        return catchupAddressMap;
    }

    private static ClusterId getClusterId(HazelcastInstance hazelcastInstance) {
        IAtomicReference uuidReference = hazelcastInstance.getAtomicReference(CLUSTER_UUID);
        UUID uuid = (UUID)uuidReference.get();
        return uuid != null ? new ClusterId(uuid) : null;
    }

    static boolean casClusterId(HazelcastInstance hazelcastInstance, ClusterId clusterId) {
        IAtomicReference uuidReference = hazelcastInstance.getAtomicReference(CLUSTER_UUID);
        return uuidReference.compareAndSet(null, (Object)clusterId.uuid()) || ((UUID)uuidReference.get()).equals(clusterId.uuid());
    }

    private static Map<MemberId, ReadReplicaInfo> readReplicas(HazelcastInstance hazelcastInstance) {
        IMap clientAddressMap = hazelcastInstance.getMap(READ_REPLICA_BOLT_ADDRESS_MAP_NAME);
        IMap txServerMap = hazelcastInstance.getMap(READ_REPLICA_TRANSACTION_SERVER_ADDRESS_MAP_NAME);
        IMap memberIdMap = hazelcastInstance.getMap(READ_REPLICA_MEMBER_ID_MAP_NAME);
        MultiMap serverGroups = hazelcastInstance.getMultiMap(SERVER_GROUPS_MULTIMAP_NAME);
        HashMap<MemberId, ReadReplicaInfo> result = new HashMap<MemberId, ReadReplicaInfo>();
        for (String hzUUID : clientAddressMap.keySet()) {
            ClientConnectorAddresses clientConnectorAddresses = ClientConnectorAddresses.fromString((String)clientAddressMap.get((Object)hzUUID));
            AdvertisedSocketAddress catchupAddress = (AdvertisedSocketAddress)SocketAddressParser.socketAddress((String)((String)txServerMap.get((Object)hzUUID)), AdvertisedSocketAddress::new);
            result.put(new MemberId(UUID.fromString((String)memberIdMap.get((Object)hzUUID))), new ReadReplicaInfo(clientConnectorAddresses, catchupAddress, Iterables.asSet((Iterable)serverGroups.get((Object)hzUUID))));
        }
        return result;
    }

    private static boolean canBeBootstrapped(HazelcastInstance hazelcastInstance, Config config) {
        Set members = hazelcastInstance.getCluster().getMembers();
        Boolean refuseToBeLeader = RefuseToBeLeaderStrategy.shouldRefuseToBeLeader(config);
        if (refuseToBeLeader.booleanValue()) {
            return false;
        }
        for (Member member : members) {
            if (member.getBooleanAttribute(REFUSE_TO_BE_LEADER_KEY).booleanValue()) continue;
            return member.localMember();
        }
        return false;
    }

    static Map<MemberId, CoreServerInfo> toCoreMemberMap(Set<Member> members, Log log, HazelcastInstance hazelcastInstance) {
        HashMap<MemberId, CoreServerInfo> coreMembers = new HashMap<MemberId, CoreServerInfo>();
        MultiMap serverGroupsMMap = hazelcastInstance.getMultiMap(SERVER_GROUPS_MULTIMAP_NAME);
        for (Member member : members) {
            try {
                MemberId memberId = new MemberId(UUID.fromString(member.getStringAttribute(MEMBER_UUID)));
                CoreServerInfo coreServerInfo = new CoreServerInfo((AdvertisedSocketAddress)SocketAddressParser.socketAddress((String)member.getStringAttribute(RAFT_SERVER), AdvertisedSocketAddress::new), (AdvertisedSocketAddress)SocketAddressParser.socketAddress((String)member.getStringAttribute(TRANSACTION_SERVER), AdvertisedSocketAddress::new), ClientConnectorAddresses.fromString(member.getStringAttribute(CLIENT_CONNECTOR_ADDRESSES)), Iterables.asSet((Iterable)serverGroupsMMap.get((Object)memberId.getUuid().toString())));
                coreMembers.put(memberId, coreServerInfo);
            }
            catch (IllegalArgumentException e) {
                log.warn("Incomplete member attributes supplied from Hazelcast", (Throwable)e);
            }
        }
        return coreMembers;
    }

    static void refreshGroups(HazelcastInstance hazelcastInstance, String memberId, List<String> groups) {
        MultiMap groupsMap = hazelcastInstance.getMultiMap(SERVER_GROUPS_MULTIMAP_NAME);
        Collection existing = groupsMap.get((Object)memberId);
        Set<String> superfluous = existing.stream().filter(t -> !groups.contains(t)).collect(Collectors.toSet());
        Set<String> missing = groups.stream().filter(t -> !existing.contains(t)).collect(Collectors.toSet());
        missing.forEach(group -> groupsMap.put((Object)memberId, group));
        superfluous.forEach(group -> groupsMap.remove((Object)memberId, group));
    }

    static MemberAttributeConfig buildMemberAttributesForCore(MemberId myself, Config config) {
        MemberAttributeConfig memberAttributeConfig = new MemberAttributeConfig();
        memberAttributeConfig.setStringAttribute(MEMBER_UUID, myself.getUuid().toString());
        AdvertisedSocketAddress discoveryAddress = (AdvertisedSocketAddress)config.get(CausalClusteringSettings.discovery_advertised_address);
        memberAttributeConfig.setStringAttribute(DISCOVERY_SERVER, discoveryAddress.toString());
        AdvertisedSocketAddress transactionSource = (AdvertisedSocketAddress)config.get(CausalClusteringSettings.transaction_advertised_address);
        memberAttributeConfig.setStringAttribute(TRANSACTION_SERVER, transactionSource.toString());
        AdvertisedSocketAddress raftAddress = (AdvertisedSocketAddress)config.get(CausalClusteringSettings.raft_advertised_address);
        memberAttributeConfig.setStringAttribute(RAFT_SERVER, raftAddress.toString());
        ClientConnectorAddresses clientConnectorAddresses = ClientConnectorAddresses.extractFromConfig(config);
        memberAttributeConfig.setStringAttribute(CLIENT_CONNECTOR_ADDRESSES, clientConnectorAddresses.toString());
        memberAttributeConfig.setBooleanAttribute(REFUSE_TO_BE_LEADER_KEY, RefuseToBeLeaderStrategy.shouldRefuseToBeLeader(config));
        return memberAttributeConfig;
    }
}

