/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import com.hazelcast.config.Config;
import com.hazelcast.config.InterfacesConfig;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.MemberAttributeConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.spi.properties.GroupProperty;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.ClientConnectorAddresses;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.CoreTopologyListenerService;
import org.neo4j.causalclustering.discovery.CoreTopologyService;
import org.neo4j.causalclustering.discovery.HazelcastClusterTopology;
import org.neo4j.causalclustering.discovery.HazelcastSslConfiguration;
import org.neo4j.causalclustering.discovery.HostnameResolver;
import org.neo4j.causalclustering.discovery.ReadReplicaTopology;
import org.neo4j.causalclustering.discovery.TopologyDifference;
import org.neo4j.causalclustering.helper.RobustJobSchedulerWrapper;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.function.ThrowingAction;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.ssl.SslPolicy;

class HazelcastCoreTopologyService
extends LifecycleAdapter
implements CoreTopologyService {
    private static final long HAZELCAST_IS_HEALTHY_TIMEOUT_MS = TimeUnit.MINUTES.toMillis(10L);
    private final org.neo4j.kernel.configuration.Config config;
    private final SslPolicy sslPolicy;
    private final MemberId myself;
    private final Log log;
    private final Log userLog;
    private final CoreTopologyListenerService listenerService;
    private final RobustJobSchedulerWrapper scheduler;
    private final long refreshPeriod;
    private final LogProvider logProvider;
    private final HostnameResolver hostnameResolver;
    private String membershipRegistrationId;
    private JobScheduler.JobHandle refreshJob;
    private volatile HazelcastInstance hazelcastInstance;
    private volatile ReadReplicaTopology readReplicaTopology = ReadReplicaTopology.EMPTY;
    private volatile CoreTopology coreTopology = CoreTopology.EMPTY;
    private volatile Map<MemberId, AdvertisedSocketAddress> catchupAddressMap = new HashMap<MemberId, AdvertisedSocketAddress>();
    private Thread startingThread;
    private volatile boolean stopped;

    HazelcastCoreTopologyService(org.neo4j.kernel.configuration.Config config, SslPolicy sslPolicy, MemberId myself, JobScheduler jobScheduler, LogProvider logProvider, LogProvider userLogProvider, HostnameResolver hostnameResolver) {
        this.config = config;
        this.sslPolicy = sslPolicy;
        this.myself = myself;
        this.listenerService = new CoreTopologyListenerService();
        this.log = logProvider.getLog(this.getClass());
        this.logProvider = logProvider;
        this.scheduler = new RobustJobSchedulerWrapper(jobScheduler, this.log);
        this.userLog = userLogProvider.getLog(this.getClass());
        this.refreshPeriod = ((Duration)config.get(CausalClusteringSettings.cluster_topology_refresh)).toMillis();
        this.hostnameResolver = hostnameResolver;
    }

    @Override
    public void addCoreTopologyListener(CoreTopologyService.Listener listener) {
        this.listenerService.addCoreTopologyListener(listener);
        listener.onCoreTopologyChange(this.coreTopology);
    }

    @Override
    public boolean setClusterId(ClusterId clusterId) throws InterruptedException {
        this.waitOnHazelcastInstanceCreation();
        return HazelcastClusterTopology.casClusterId(this.hazelcastInstance, clusterId);
    }

    public void start() throws Throwable {
        this.startingThread = new Thread(() -> {
            this.log.info("Cluster discovery service starting");
            this.hazelcastInstance = this.createHazelcastInstance();
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            this.membershipRegistrationId = this.hazelcastInstance.getCluster().addMembershipListener((MembershipListener)new OurMembershipListener());
            this.refreshJob = this.scheduler.scheduleRecurring("TopologyRefresh", this.refreshPeriod, (ThrowingAction<Exception>)((ThrowingAction)this::refreshTopology));
            this.log.info("Cluster discovery service started");
        });
        this.startingThread.setDaemon(true);
        this.startingThread.setName("HZ Starting Thread");
        this.startingThread.start();
    }

    public void stop() {
        this.log.info(String.format("HazelcastCoreTopologyService stopping and unbinding from %s", this.config.get(CausalClusteringSettings.discovery_listen_address)));
        this.startingThread.interrupt();
        this.stopped = true;
        if (this.refreshJob != null) {
            this.scheduler.cancelAndWaitTermination(this.refreshJob);
        }
        if (this.hazelcastInstance != null && this.membershipRegistrationId != null) {
            try {
                this.hazelcastInstance.getCluster().removeMembershipListener(this.membershipRegistrationId);
                this.hazelcastInstance.getLifecycleService().terminate();
            }
            catch (Throwable e) {
                this.log.warn("Failed to stop Hazelcast", e);
            }
        }
    }

    private HazelcastInstance createHazelcastInstance() {
        System.setProperty(GroupProperty.WAIT_SECONDS_BEFORE_JOIN.getName(), "1");
        JoinConfig joinConfig = new JoinConfig();
        joinConfig.getMulticastConfig().setEnabled(false);
        TcpIpConfig tcpIpConfig = joinConfig.getTcpIpConfig();
        tcpIpConfig.setEnabled(true);
        List initialMembers = (List)this.config.get(CausalClusteringSettings.initial_discovery_members);
        for (AdvertisedSocketAddress address : initialMembers) {
            for (AdvertisedSocketAddress advertisedSocketAddress : this.hostnameResolver.resolve(address)) {
                tcpIpConfig.addMember(advertisedSocketAddress.toString());
            }
        }
        ListenSocketAddress hazelcastAddress = (ListenSocketAddress)this.config.get(CausalClusteringSettings.discovery_listen_address);
        NetworkConfig networkConfig = new NetworkConfig();
        if (!hazelcastAddress.isWildcard()) {
            InterfacesConfig interfaces = new InterfacesConfig();
            interfaces.addInterface(hazelcastAddress.getHostname());
            interfaces.setEnabled(true);
            networkConfig.setInterfaces(interfaces);
        }
        HazelcastSslConfiguration.configureSsl(networkConfig, this.sslPolicy, this.logProvider);
        networkConfig.setPort(hazelcastAddress.getPort());
        networkConfig.setJoin(joinConfig);
        networkConfig.setPortAutoIncrement(false);
        Long electionTimeoutMillis = ((Duration)this.config.get(CausalClusteringSettings.leader_election_timeout)).toMillis();
        Long baseHazelcastTimeoutMillis = 3L * electionTimeoutMillis / 2L;
        long baseHazelcastTimeoutSeconds = (baseHazelcastTimeoutMillis + 1000L - 1L) / 1000L;
        Config c = new Config();
        c.setProperty(GroupProperty.OPERATION_CALL_TIMEOUT_MILLIS.getName(), String.valueOf(baseHazelcastTimeoutMillis));
        c.setProperty(GroupProperty.MERGE_NEXT_RUN_DELAY_SECONDS.getName(), String.valueOf(baseHazelcastTimeoutSeconds));
        c.setProperty(GroupProperty.MERGE_FIRST_RUN_DELAY_SECONDS.getName(), String.valueOf(baseHazelcastTimeoutSeconds));
        c.setProperty(GroupProperty.INITIAL_MIN_CLUSTER_SIZE.getName(), String.valueOf(this.minimumClusterSizeThatCanTolerateOneFaultForExpectedClusterSize()));
        if (((Boolean)this.config.get(CausalClusteringSettings.disable_middleware_logging)).booleanValue()) {
            c.setProperty(GroupProperty.LOGGING_TYPE.getName(), "none");
        }
        if (hazelcastAddress.isIPv6()) {
            c.setProperty(GroupProperty.PREFER_IPv4_STACK.getName(), "false");
        }
        c.setNetworkConfig(networkConfig);
        MemberAttributeConfig memberAttributeConfig = HazelcastClusterTopology.buildMemberAttributesForCore(this.myself, this.config);
        c.setMemberAttributeConfig(memberAttributeConfig);
        this.logConnectionInfo(initialMembers);
        JobScheduler.JobHandle logJob = this.scheduler.schedule("HazelcastHealth", HAZELCAST_IS_HEALTHY_TIMEOUT_MS, (ThrowingAction<Exception>)((ThrowingAction)() -> this.log.warn("The server has not been able to connect in a timely fashion to the cluster. Please consult the logs for more details. Rebooting the server may solve the problem.")));
        try {
            this.hazelcastInstance = Hazelcast.newHazelcastInstance((Config)c);
            logJob.cancel(true);
        }
        catch (HazelcastException e) {
            String errorMessage = String.format("Hazelcast was unable to start with setting: %s = %s", CausalClusteringSettings.discovery_listen_address.name(), this.config.get(CausalClusteringSettings.discovery_listen_address));
            this.userLog.error(errorMessage);
            this.log.error(errorMessage, (Throwable)e);
            throw new RuntimeException(e);
        }
        List groups = (List)this.config.get(CausalClusteringSettings.server_groups);
        HazelcastClusterTopology.refreshGroups(this.hazelcastInstance, this.myself.getUuid().toString(), groups);
        return this.hazelcastInstance;
    }

    private void logConnectionInfo(List<AdvertisedSocketAddress> initialMembers) {
        this.userLog.info("My connection info: [\n\tDiscovery:   listen=%s, advertised=%s,\n\tTransaction: listen=%s, advertised=%s, \n\tRaft:        listen=%s, advertised=%s, \n\tClient Connector Addresses: %s\n]", new Object[]{this.config.get(CausalClusteringSettings.discovery_listen_address), this.config.get(CausalClusteringSettings.discovery_advertised_address), this.config.get(CausalClusteringSettings.transaction_listen_address), this.config.get(CausalClusteringSettings.transaction_advertised_address), this.config.get(CausalClusteringSettings.raft_listen_address), this.config.get(CausalClusteringSettings.raft_advertised_address), ClientConnectorAddresses.extractFromConfig(this.config)});
        this.userLog.info("Discovering cluster with initial members: " + initialMembers);
        this.userLog.info("Attempting to connect to the other cluster members before continuing...");
    }

    private Integer minimumClusterSizeThatCanTolerateOneFaultForExpectedClusterSize() {
        return (Integer)this.config.get(CausalClusteringSettings.expected_core_cluster_size) / 2 + 1;
    }

    @Override
    public CoreTopology coreServers() {
        return this.coreTopology;
    }

    @Override
    public ReadReplicaTopology readReplicas() {
        return this.readReplicaTopology;
    }

    @Override
    public Optional<AdvertisedSocketAddress> findCatchupAddress(MemberId memberId) {
        return Optional.ofNullable(this.catchupAddressMap.get(memberId));
    }

    private synchronized void refreshTopology() throws InterruptedException {
        this.refreshCoreTopology();
        this.refreshReadReplicaTopology();
        this.catchupAddressMap = HazelcastClusterTopology.extractCatchupAddressesMap(this.coreTopology, this.readReplicaTopology);
    }

    private void refreshCoreTopology() throws InterruptedException {
        this.waitOnHazelcastInstanceCreation();
        CoreTopology newCoreTopology = HazelcastClusterTopology.getCoreTopology(this.hazelcastInstance, this.config, this.log);
        TopologyDifference difference = this.coreTopology.difference(newCoreTopology);
        if (difference.hasChanges()) {
            this.log.info("Core topology changed %s", new Object[]{difference});
        }
        this.coreTopology = newCoreTopology;
        this.listenerService.notifyListeners(this.coreTopology);
    }

    private void refreshReadReplicaTopology() throws InterruptedException {
        this.waitOnHazelcastInstanceCreation();
        ReadReplicaTopology newReadReplicaTopology = HazelcastClusterTopology.getReadReplicaTopology(this.hazelcastInstance, this.log);
        TopologyDifference difference = this.readReplicaTopology.difference(newReadReplicaTopology);
        if (difference.hasChanges()) {
            this.log.info("Read replica topology changed %s", new Object[]{difference});
        }
        this.readReplicaTopology = newReadReplicaTopology;
    }

    private void waitOnHazelcastInstanceCreation() throws InterruptedException {
        while (this.hazelcastInstance == null && !this.stopped) {
            Thread.sleep(200L);
        }
    }

    private class OurMembershipListener
    implements MembershipListener {
        private OurMembershipListener() {
        }

        public void memberAdded(MembershipEvent membershipEvent) {
            HazelcastCoreTopologyService.this.log.info("Core member added %s", new Object[]{membershipEvent});
            try {
                HazelcastCoreTopologyService.this.refreshTopology();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        public void memberRemoved(MembershipEvent membershipEvent) {
            HazelcastCoreTopologyService.this.log.info("Core member removed %s", new Object[]{membershipEvent});
            try {
                HazelcastCoreTopologyService.this.refreshTopology();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
            HazelcastCoreTopologyService.this.log.info("Core member attribute changed %s", new Object[]{memberAttributeEvent});
        }
    }
}

